/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.domain.ServerStatus;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseServerFromJsonResponseTest {
    public void testApplyInputStreamDetails() throws UnknownHostException {
        Server response = ParseServerFromJsonResponseTest.parseServer();
        Assert.assertEquals((int)response.getId(), (int)1234);
        Assert.assertEquals((String)response.getName(), (String)"sample-server");
        Assert.assertEquals((Object)response.getImageId(), (Object)new Integer(2));
        Assert.assertEquals((Object)response.getFlavorId(), (Object)new Integer(1));
        Assert.assertEquals((String)response.getHostId(), (String)"e4d909c290d0fb1ca068ffaddf22cbd0");
        Assert.assertEquals((Object)response.getStatus(), (Object)ServerStatus.BUILD);
        Assert.assertEquals((Object)response.getProgress(), (Object)new Integer(60));
        ArrayList publicAddresses = Lists.newArrayList((Object[])new String[]{"67.23.10.132", "67.23.10.131"});
        ArrayList privateAddresses = Lists.newArrayList((Object[])new String[]{"10.176.42.16"});
        Addresses addresses1 = new Addresses();
        addresses1.getPrivateAddresses().addAll(privateAddresses);
        addresses1.getPublicAddresses().addAll(publicAddresses);
        Assert.assertEquals((Object)response.getAddresses(), (Object)addresses1);
        Assert.assertEquals((Object)response.getMetadata(), (Object)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1"));
    }

    public static Server parseServer() {
        Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule()});
        InputStream is = ParseServerFromJsonResponseTest.class.getResourceAsStream("/test_get_server_detail.json");
        UnwrapOnlyJsonValue parser = (UnwrapOnlyJsonValue)i.getInstance(Key.get((TypeLiteral)new TypeLiteral<UnwrapOnlyJsonValue<Server>>(){}));
        Server response = (Server)parser.apply(new HttpResponse(200, "ok", (Payload)Payloads.newInputStreamPayload((InputStream)is)));
        return response;
    }
}

