/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.binders;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.jclouds.cloudservers.binders.BindRebootTypeToJsonPayload;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindRebootTypeToJsonPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule()});

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPostIsIncorrect() {
        BindRebootTypeToJsonPayload binder = new BindRebootTypeToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Map)ImmutableMap.of((Object)"adminPass", (Object)"foo"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeRebootType() {
        BindRebootTypeToJsonPayload binder = new BindRebootTypeToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test
    public void testHard() {
        BindRebootTypeToJsonPayload binder = new BindRebootTypeToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)RebootType.HARD);
        Assert.assertEquals((Object)"{\"reboot\":{\"type\":\"HARD\"}}", (Object)request.getPayload().getRawContent());
    }

    @Test
    public void testSoft() {
        BindRebootTypeToJsonPayload binder = new BindRebootTypeToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, (Object)RebootType.SOFT);
        Assert.assertEquals((Object)"{\"reboot\":{\"type\":\"SOFT\"}}", (Object)request.getPayload().getRawContent());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindRebootTypeToJsonPayload binder = new BindRebootTypeToJsonPayload();
        this.injector.injectMembers((Object)binder);
        HttpRequest request = new HttpRequest("POST", URI.create("http://localhost"));
        binder.bindToRequest(request, null);
    }
}

