/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.config.CloudServersRestClientModule;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.cloudservers.domain.DailyBackup;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.cloudservers.domain.WeeklyBackup;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.cloudservers.options.CreateSharedIpGroupOptions;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.cloudservers.options.RebuildServerOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnFalseOn404;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.TestOpenStackAuthenticationModule;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.filters.AddTimestampQuery;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudServersAsyncClientTest")
public class CloudServersAsyncClientTest
extends RestClientTest<CloudServersAsyncClient> {
    private static final Class<? extends ListOptions[]> listOptionsVarargsClass = new ListOptions[0].getClass();
    private static final Class<? extends CreateServerOptions[]> createServerOptionsVarargsClass = new CreateServerOptions[0].getClass();
    Date now = new Date(10000000L);
    private static final Class<? extends CreateSharedIpGroupOptions[]> createSharedIpGroupOptionsVarargsClass = new CreateSharedIpGroupOptions[0].getClass();
    private static final Class<? extends RebuildServerOptions[]> rebuildServerOptionsVarargsClass = new RebuildServerOptions[0].getClass();
    protected String provider = "cloudservers";

    public void testCreateServer() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createServer", String.class, Integer.TYPE, Integer.TYPE, createServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2, 1});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createServer", String.class, Integer.TYPE, Integer.TYPE, createServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2, 1, CreateServerOptions.Builder.withSharedIpGroup((int)2)});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"sharedIpGroupId\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithFile() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createServer", String.class, Integer.TYPE, Integer.TYPE, createServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2, 1, CreateServerOptions.Builder.withFile((String)"/etc/jclouds", (byte[])"foo".getBytes())});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"personality\":[{\"path\":\"/etc/jclouds\",\"contents\":\"Zm9v\"}]}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithMetadata() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createServer", String.class, Integer.TYPE, Integer.TYPE, createServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2, 1, CreateServerOptions.Builder.withMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"))});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"metadata\":{\"foo\":\"bar\"}}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithIpGroupAndSharedIp() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Method method = CloudServersAsyncClient.class.getMethod("createServer", String.class, Integer.TYPE, Integer.TYPE, createServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2, 1, CreateServerOptions.Builder.withSharedIpGroup((int)2).withSharedIp("127.0.0.1")});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"sharedIpGroupId\":2,\"addresses\":{\"public\":[\"127.0.0.1\"]}}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteImage() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("deleteImage", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE http://serverManagementUrl/images/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServers() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listServers", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServersOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listServers", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServersDetail() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listServers", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails()});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetServer() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getServer", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavors() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listFlavors", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/flavors?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listFlavors", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/flavors?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsDetail() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listFlavors", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails()});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/flavors/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listFlavors", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/flavors/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetFlavor() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getFlavor", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/flavors/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImages() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listImages", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/images?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesDetail() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listImages", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails()});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/images/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listImages", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/images?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listImages", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/images/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetImage() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getImage", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/images/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteServer() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("deleteServer", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE http://serverManagementUrl/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testShareIpNoConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Method method = CloudServersAsyncClient.class.getMethod("shareIp", String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"127.0.0.1", 2, 3, false});
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://serverManagementUrl/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"shareIp\":{\"sharedIpGroupId\":3}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testShareIpConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Method method = CloudServersAsyncClient.class.getMethod("shareIp", String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"127.0.0.1", 2, 3, true});
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://serverManagementUrl/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"shareIp\":{\"sharedIpGroupId\":3,\"configureServer\":true}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUnshareIpNoConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Method method = CloudServersAsyncClient.class.getMethod("unshareIp", String.class, Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"127.0.0.1", 2, 3, false});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE http://serverManagementUrl/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testReplaceBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("replaceBackupSchedule", Integer.TYPE, BackupSchedule.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2, new BackupSchedule(WeeklyBackup.MONDAY, DailyBackup.H_0800_1000, true)});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/2/backup_schedule HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"backupSchedule\":{\"daily\":\"H_0800_1000\",\"enabled\":true,\"weekly\":\"MONDAY\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOn404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("deleteBackupSchedule", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE http://serverManagementUrl/servers/2/backup_schedule HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testChangeAdminPass() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("changeAdminPass", Integer.TYPE, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2, "foo"});
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://serverManagementUrl/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"adminPass\":\"foo\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testChangeServerName() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("renameServer", Integer.TYPE, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2, "foo"});
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://serverManagementUrl/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"foo\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroups() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listSharedIpGroups", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[0]);
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listSharedIpGroups", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/shared_ip_groups?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsDetail() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listSharedIpGroups", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails()});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/shared_ip_groups/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listSharedIpGroups", listOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/shared_ip_groups/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getSharedIpGroup", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/shared_ip_groups/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createSharedIpGroup", String.class, createSharedIpGroupOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie"});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"sharedIpGroup\":{\"name\":\"ralphie\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSharedIpGroupWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createSharedIpGroup", String.class, createSharedIpGroupOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", CreateSharedIpGroupOptions.Builder.withServer((int)2)});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"sharedIpGroup\":{\"name\":\"ralphie\",\"server\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("deleteSharedIpGroup", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE http://serverManagementUrl/shared_ip_groups/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnFalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getAddresses", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/2/ips?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListPublicAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listPublicAddresses", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/2/ips/public?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListPrivateAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("listPrivateAddresses", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/2/ips/private?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("getBackupSchedule", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "GET http://serverManagementUrl/servers/2/backup_schedule?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateImageWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("createImageFromServer", String.class, Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"ralphie", 2});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/images?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"image\":{\"serverId\":2,\"name\":\"ralphie\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebuildServer() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("rebuildServer", Integer.TYPE, rebuildServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{3});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/3/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"rebuild\":{}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebuildServerWithImage() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("rebuildServer", Integer.TYPE, rebuildServerOptionsVarargsClass);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{3, RebuildServerOptions.Builder.withImage((int)2)});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/3/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"rebuild\":{\"imageId\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testReboot() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("rebootServer", Integer.TYPE, RebootType.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2, RebootType.HARD});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"reboot\":{\"type\":\"HARD\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResize() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("resizeServer", Integer.TYPE, Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2, 3});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"resize\":{\"flavorId\":3}}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfirmResize() throws IOException, IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("confirmResizeServer", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"confirmResize\":null}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevertResize() throws IOException, SecurityException, NoSuchMethodException {
        Method method = CloudServersAsyncClient.class.getMethod("revertResizeServer", Integer.TYPE);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{2});
        this.assertRequestLineEquals((HttpRequest)request, "POST http://serverManagementUrl/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"revertResize\":null}", "application/json", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected TypeLiteral<RestAnnotationProcessor<CloudServersAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<CloudServersAsyncClient>>(){};
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)2);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), AuthenticateRequest.class);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(1)).getClass(), AddTimestampQuery.class);
    }

    protected Module createModule() {
        return new TestCloudServersRestClientModule();
    }

    public RestContextSpec<CloudServersClient, CloudServersAsyncClient> createContextSpec() {
        return new RestContextFactory().createContextSpec(this.provider, "user", "password", new Properties());
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.regions", "US");
        properties.setProperty("jclouds.endpoint", "https://auth");
        properties.setProperty("jclouds.api-version", "1");
        return properties;
    }

    @ConfiguresRestClient
    @RequiresHttp
    protected static class TestCloudServersRestClientModule
    extends CloudServersRestClientModule {
        private TestCloudServersRestClientModule() {
            super((OpenStackAuthenticationModule)new TestOpenStackAuthenticationModule());
        }

        protected URI provideServerUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
            return URI.create("http://serverManagementUrl");
        }
    }
}

