/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.app.program.manual.backup;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Vector;
import org.jbundle.app.program.db.ClassInfo;
import org.jbundle.base.db.Record;
import org.jbundle.base.db.util.log.BackupConstants;
import org.jbundle.base.db.util.log.FileList;
import org.jbundle.base.model.RecordOwner;
import org.jbundle.base.thread.BaseProcess;
import org.jbundle.model.DBException;
import org.jbundle.model.RecordOwnerParent;
import org.jbundle.thin.base.db.FieldList;
import org.jbundle.thin.base.db.buff.VectorBuffer;

public class RestoreBackupProcess
extends BaseProcess
implements BackupConstants {
    protected ObjectInputStream m_reader = null;

    public RestoreBackupProcess() {
    }

    public RestoreBackupProcess(RecordOwnerParent taskParent, Record recordMain, Map<String, Object> properties) {
        this();
        this.init(taskParent, recordMain, properties);
    }

    public void init(RecordOwnerParent taskParent, Record recordMain, Map<String, Object> properties) {
        super.init(taskParent, recordMain, properties);
    }

    public Record openMainRecord() {
        return new ClassInfo((RecordOwner)this);
    }

    public void openOtherRecords() {
        super.openOtherRecords();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object objMessage = null;
        String[] files = this.getFileList();
        if (files == null) {
            return;
        }
        String[] stringArray = files;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strFile = stringArray[n2];
            this.m_reader = this.getReader(strFile);
            try {
                while (true) {
                    String strKey;
                    String strTableName;
                    String strTrxType;
                    block21: {
                        if ((objMessage = this.m_reader.readObject()) == null) {
                            this.m_reader.close();
                            this.m_reader = null;
                            break;
                        }
                        VectorBuffer buffer = new VectorBuffer((Vector)objMessage, 9);
                        buffer.setHeaderCount(3);
                        strTrxType = buffer.getHeader().toString();
                        strTableName = buffer.getHeader().toString();
                        strKey = buffer.getHeader().toString();
                        try {
                            Record record = this.getRecord(strTableName);
                            if (record == null) {
                                ClassInfo recClassInfo = (ClassInfo)this.getMainRecord();
                                recClassInfo.addNew();
                                recClassInfo.setKeyArea("ClassName");
                                recClassInfo.getField("ClassName").setString(strTableName);
                                if (recClassInfo.seek("=")) {
                                    strTableName = recClassInfo.getPackageName(null) + '.' + strTableName;
                                    record = Record.makeRecordFromClassName((String)strTableName, (RecordOwner)this);
                                    this.disableAllListeners(record);
                                    record.setAutoSequence(false);
                                } else {
                                    if ("NOTRX".equalsIgnoreCase(strTrxType)) continue;
                                    System.out.println("Error - table not found: " + strTableName);
                                    continue;
                                }
                            }
                            record.addNew();
                            record.getCounterField().setString(strKey);
                            if ("add".equalsIgnoreCase(strTrxType)) {
                                buffer.bufferToFields((FieldList)record, true, 2);
                                record.add();
                                break block21;
                            }
                            if ("set".equalsIgnoreCase(strTrxType)) {
                                if (record.seek("=")) {
                                    record.edit();
                                    buffer.bufferToFields((FieldList)record, true, 2);
                                    record.set();
                                    break block21;
                                } else {
                                    System.out.println("Error - record not found: " + strTableName + ", key: " + strKey);
                                }
                                break block21;
                            }
                            if (!"remove".equalsIgnoreCase(strTrxType)) break block21;
                            if (record.seek("=")) {
                                record.edit();
                                record.remove();
                            } else {
                                System.out.println("Error - record not found: " + strTableName + ", key: " + strKey);
                            }
                        }
                        catch (DBException e) {
                            e.printStackTrace();
                            System.out.println("Error - record: " + strTableName + ", key: " + strKey + " trx type: " + strTrxType);
                        }
                    }
                    System.out.println("trxType: " + strTrxType + " record: " + strTableName + " key: " + strKey);
                }
            }
            catch (EOFException buffer) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return;
    }

    public String[] getFileList() {
        String strDirname;
        String[] files = null;
        String strFilename = this.getProperty("filename");
        if (strFilename != null) {
            files = new String[]{strFilename};
        }
        if ((strDirname = this.getProperty("folder")) != null) {
            FileList list = new FileList(strDirname);
            files = list.getFileNames();
            if (!strDirname.endsWith("/")) {
                strDirname = strDirname + "/";
            }
            for (int i = 0; i < files.length; ++i) {
                files[i] = strDirname + files[i];
            }
        }
        return files;
    }

    public ObjectInputStream getReader(String strFilename) {
        ObjectInputStream reader = null;
        try {
            InputStream is = null;
            if (strFilename.indexOf(58) == -1) {
                is = new FileInputStream(strFilename);
            } else {
                URL url = new URL(strFilename);
                URLConnection urlc = url.openConnection();
                is = urlc.getInputStream();
            }
            reader = new ObjectInputStream(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public void disableAllListeners(Record record) {
        record.setEnableListeners(false);
        record.setEnableFieldListeners(false);
    }
}

