/*
 * Decompiled with CFR 0.152.
 */
package org.jbundle.app.program.manual.backup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.Timer;
import org.jbundle.base.db.util.log.BackupConstants;
import org.jbundle.model.App;
import org.jbundle.model.message.MessageFilter;
import org.jbundle.model.message.MessageManager;
import org.jbundle.model.util.Util;
import org.jbundle.thin.base.message.BaseMessage;
import org.jbundle.thin.base.message.BaseMessageFilter;
import org.jbundle.thin.base.message.BaseMessageListener;
import org.jbundle.thin.base.message.BaseMessageReceiver;
import org.jbundle.thin.base.screen.ThinApplication;
import org.jbundle.thin.base.util.message.RemoteMessageManager;

public class BackupServerApp
extends ThinApplication
implements BackupConstants,
ActionListener {
    protected ObjectOutputStream m_writer = null;
    protected String m_strFilenameTemplate = null;
    protected Timer m_cycletimer = null;
    protected Timer m_timeouttimer = null;
    protected double m_lastWrite = 0.0;
    protected int iCycleTime = -1;
    protected BaseMessageFilter m_messageFilter = null;
    public static Vector<Object> FAKE_TRX = new Vector();

    public BackupServerApp() {
    }

    public BackupServerApp(String[] args) {
        this();
        Hashtable<String, Object> properties = null;
        if (args != null) {
            properties = new Hashtable<String, Object>();
            Util.parseArgs(properties, (String[])args);
        }
        this.init(null, properties, null);
    }

    public void init(Object env, Map<String, Object> properties, Object applet) {
        super.init(env, properties, applet);
        if (this.registerUniqueApplication("backup", "internet") != 0) {
            this.free();
            return;
        }
        MessageManager messageManager = RemoteMessageManager.getMessageManager((App)this);
        BaseMessageReceiver receiver = (BaseMessageReceiver)messageManager.getMessageQueue("backup", "internet").getMessageReceiver();
        this.m_messageFilter = new BaseMessageFilter("backup", "internet", (Object)this, null);
        new BaseMessageListener(this.m_messageFilter){

            public int handleMessage(BaseMessage message) {
                Object objMessage = message.get("message");
                BackupServerApp.this.backupTrxLog(objMessage);
                return 0;
            }
        };
        receiver.addMessageFilter((MessageFilter)this.m_messageFilter);
    }

    public void free() {
        if (this.m_cycletimer != null) {
            this.m_cycletimer.stop();
        }
        this.m_cycletimer = null;
        this.startNextFile();
        super.free();
    }

    public synchronized void backupTrxLog(Object objMessage) {
        try {
            this.getWriter().writeObject(objMessage);
            this.m_lastWrite = System.currentTimeMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void startNextFile() {
        if (this.m_writer == null) {
            return;
        }
        try {
            this.getWriter().close();
            this.m_writer = null;
            if (this.m_timeouttimer != null) {
                this.m_timeouttimer.stop();
            }
            this.m_lastWrite = System.currentTimeMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ObjectOutputStream getWriter() {
        if (this.m_writer == null) {
            try {
                String filename = this.getFilename();
                OutputStream os = null;
                if (filename.indexOf(58) == -1) {
                    os = new FileOutputStream(filename);
                } else {
                    URL url = new URL(filename);
                    URLConnection urlc = url.openConnection();
                    os = urlc.getOutputStream();
                }
                this.m_writer = new ObjectOutputStream(os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_writer;
    }

    public String getFilename() {
        String filename;
        if (this.m_strFilenameTemplate == null) {
            this.m_strFilenameTemplate = this.getProperty("filenametemplate");
        }
        if (this.m_strFilenameTemplate == null) {
            this.m_strFilenameTemplate = "trxlog_{0}.txt";
        }
        if (this.getProperty("folder") != null) {
            String strFolder = this.getProperty("folder");
            if (!strFolder.endsWith("/")) {
                strFolder = strFolder + "/";
            }
            this.m_strFilenameTemplate = strFolder + this.m_strFilenameTemplate;
        }
        if (!(filename = this.getBackupFilename(this.m_strFilenameTemplate)).equalsIgnoreCase(this.m_strFilenameTemplate)) {
            if (this.getProperty("cycletime") != null) {
                int iCycleTime = Integer.parseInt(this.getProperty("cycletime"));
                if (iCycleTime < 10000) {
                    iCycleTime = iCycleTime * 1000 * 60;
                }
                this.startCycleTimer(iCycleTime);
            }
            if (this.getProperty("timeouttime") != null) {
                this.iCycleTime = Integer.parseInt(this.getProperty("timeouttime"));
                this.m_lastWrite = System.currentTimeMillis();
                this.startTimeoutTimer(this.iCycleTime);
            }
        }
        return filename;
    }

    public static void main(String[] args) {
        new BackupServerApp(args);
    }

    public String getBackupFilename(String strFilenameTemplate) {
        Date now = new Date();
        String strDate = this.dateToString(now);
        for (int i = 0; i < strDate.length(); ++i) {
            char ch = strDate.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            strDate = strDate.substring(0, i) + '_' + strDate.substring(i + 1, strDate.length());
        }
        return MessageFormat.format(strFilenameTemplate, strDate);
    }

    public String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void startCycleTimer(int iDelayMS) {
        if (this.m_cycletimer == null) {
            this.m_cycletimer = new Timer(iDelayMS, this);
            this.m_cycletimer.setRepeats(false);
            this.m_cycletimer.start();
        } else {
            this.m_cycletimer.restart();
        }
    }

    public void startTimeoutTimer(int iDelayMS) {
        if (this.m_timeouttimer == null) {
            this.m_timeouttimer = new Timer(iDelayMS, this);
            this.m_timeouttimer.setRepeats(false);
            this.m_timeouttimer.start();
        } else {
            this.m_timeouttimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_cycletimer) {
            this.startNextFile();
        } else if (e.getSource() == this.m_timeouttimer) {
            this.checkTimeout();
        }
    }

    public void checkTimeout() {
        int iTimeSinceLastActivity = (int)((double)System.currentTimeMillis() - this.m_lastWrite);
        if (this.iCycleTime != -1) {
            if (iTimeSinceLastActivity < this.iCycleTime) {
                if (this.m_writer != null) {
                    this.flush(true);
                }
                this.m_timeouttimer.restart();
            } else {
                this.startNextFile();
            }
        }
    }

    public synchronized void flush(boolean bSendFakeTrx) {
        try {
            if (bSendFakeTrx) {
                this.getWriter().writeObject(FAKE_TRX);
            }
            this.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Object[] FAKE_DATA = new Object[]{"NOTRX", "", "0"};
        for (int i = 0; i < FAKE_DATA.length; ++i) {
            FAKE_TRX.add(FAKE_DATA[i]);
        }
    }
}

