/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.process.workitem.wsht.HumanTaskHandlerHelper;
import org.jbpm.task.Content;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Status;
import org.jbpm.task.SubTasksStrategy;
import org.jbpm.task.SubTasksStrategyFactory;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.event.entity.TaskCompletedEvent;
import org.jbpm.task.event.entity.TaskEvent;
import org.jbpm.task.event.entity.TaskFailedEvent;
import org.jbpm.task.event.entity.TaskSkippedEvent;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.AbstractBaseResponseHandler;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.kie.SystemEventListenerFactory;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class WSHumanTaskHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(WSHumanTaskHandler.class);
    private String ipAddress = "127.0.0.1";
    private int port = 9123;
    private TaskClient client;
    private WorkItemManager manager = null;
    private boolean initialized = false;
    private KnowledgeRuntime session;
    private OnErrorAction action;

    public WSHumanTaskHandler() {
        this.action = OnErrorAction.LOG;
    }

    public WSHumanTaskHandler(KnowledgeRuntime session) {
        this.session = session;
        this.action = OnErrorAction.LOG;
    }

    public WSHumanTaskHandler(OnErrorAction action) {
        this.action = action;
    }

    public WSHumanTaskHandler(KnowledgeRuntime session, OnErrorAction action) {
        this.session = session;
        this.action = action;
    }

    public void setConnection(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    public void setClient(TaskClient client) {
        this.client = client;
    }

    public void connect() {
        if (!this.initialized) {
            if (this.client == null) {
                this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("org.drools.process.workitem.wsht.WSHumanTaskHandler", new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
                boolean connected = this.client.connect(this.ipAddress, this.port);
                if (!connected) {
                    throw new IllegalArgumentException("Could not connect task client");
                }
            }
            this.registerTaskEventHandlers();
            this.initialized = true;
        }
    }

    private void registerTaskEventHandlers() {
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, -1L);
        TaskCompletedHandler eventResponseHandler = new TaskCompletedHandler(this.manager, this.client);
        this.client.registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
        key = new TaskEventKey(TaskFailedEvent.class, -1L);
        this.client.registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
        key = new TaskEventKey(TaskSkippedEvent.class, -1L);
        this.client.registerForEvent((EventKey)key, false, (EventResponseHandler)eventResponseHandler);
    }

    public void setManager(WorkItemManager manager) {
        this.manager = manager;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String groupId;
        String subTaskStrategiesCommaSeparated;
        String comment;
        String taskName;
        if (this.manager == null) {
            this.manager = manager;
        } else if (this.manager != manager) {
            throw new IllegalArgumentException("This WSHumanTaskHandler can only be used for one WorkItemManager");
        }
        this.connect();
        Task task = new Task();
        String locale = (String)workItem.getParameter("Locale");
        if (locale == null) {
            locale = "en-UK";
        }
        if ((taskName = (String)workItem.getParameter("TaskName")) != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText(locale, taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        descriptions.add(new I18NText(locale, comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        subjects.add(new I18NText(locale, comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (this.session != null && this.session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(this.session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
        }
        if (this.session != null && this.session instanceof StatefulKnowledgeSession) {
            taskData.setProcessSessionId(((StatefulKnowledgeSession)this.session).getId());
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        if ((subTaskStrategiesCommaSeparated = (String)workItem.getParameter("SubTaskStrategies")) != null && !subTaskStrategiesCommaSeparated.equals("")) {
            String[] subTaskStrategies = subTaskStrategiesCommaSeparated.split(",");
            ArrayList<SubTasksStrategy> strategies = new ArrayList<SubTasksStrategy>();
            for (String subTaskStrategyString : subTaskStrategies) {
                SubTasksStrategy subTaskStrategy = SubTasksStrategyFactory.newStrategy((String)subTaskStrategyString);
                strategies.add(subTaskStrategy);
            }
            task.setSubTaskStrategies(strategies);
        }
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        String actorId = (String)workItem.getParameter("ActorId");
        if (actorId != null && actorId.trim().length() > 0) {
            String[] actorIds;
            for (String id : actorIds = actorId.split(",")) {
                potentialOwners.add(new User(id.trim()));
            }
            if (potentialOwners.size() > 0) {
                taskData.setCreatedBy((User)potentialOwners.get(0));
            }
        }
        if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() > 0) {
            String[] groupIds;
            for (String id : groupIds = groupId.split(",")) {
                potentialOwners.add(new Group(id.trim()));
            }
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<User> businessAdministrators = new ArrayList<User>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        task.setPeopleAssignments(assignments);
        task.setTaskData(taskData);
        ContentData content = null;
        HashMap contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = new HashMap(workItem.getParameters());
        }
        if (contentObject != null) {
            content = ContentMarshallerHelper.marshal(contentObject, (Environment)this.session.getEnvironment());
        }
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, businessAdministrators, (Environment)this.session.getEnvironment()));
        this.client.addTask(task, content, (TaskClientHandler.AddTaskResponseHandler)new TaskAddedHandler(manager, workItem.getId()));
    }

    public void dispose() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        AbortTaskResponseHandler abortTaskResponseHandler = new AbortTaskResponseHandler(this.client);
        this.client.getTaskByWorkItemId(workItem.getId(), (TaskClientHandler.GetTaskResponseHandler)abortTaskResponseHandler);
    }

    private static class AbortTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private TaskClient client;

        public AbortTaskResponseHandler(TaskClient client) {
            this.client = client;
        }

        public void execute(Task task) {
            if (task != null) {
                this.client.exit(task.getId().longValue(), "Administrator", null);
            }
        }
    }

    private static class GetResultContentResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetContentResponseHandler {
        private WorkItemManager manager;
        private Task task;
        private Map<String, Object> results;

        public GetResultContentResponseHandler(WorkItemManager manager, Task task, Map<String, Object> results) {
            this.manager = manager;
            this.task = task;
            this.results = results;
        }

        public void execute(Content content) {
            ByteArrayInputStream bis = new ByteArrayInputStream(content.getContent());
            try {
                ObjectInputStream in = new ObjectInputStream(bis);
                Object result = in.readObject();
                in.close();
                this.results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        this.results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.manager.completeWorkItem(this.task.getTaskData().getWorkItemId(), this.results);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class GetCompletedTaskResponseHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.GetTaskResponseHandler {
        private WorkItemManager manager;
        private TaskClient client;

        public GetCompletedTaskResponseHandler(WorkItemManager manager, TaskClient client) {
            this.manager = manager;
            this.client = client;
        }

        public void execute(Task task) {
            long workItemId = task.getTaskData().getWorkItemId();
            if (task.getTaskData().getStatus() == Status.Completed) {
                String userId = task.getTaskData().getActualOwner().getId();
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("ActorId", userId);
                long contentId = task.getTaskData().getOutputContentId();
                if (contentId != -1L) {
                    GetResultContentResponseHandler getContentResponseHandler = new GetResultContentResponseHandler(this.manager, task, results);
                    this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
                } else {
                    this.manager.completeWorkItem(workItemId, results);
                }
            } else {
                this.manager.abortWorkItem(workItemId);
            }
        }
    }

    private static class TaskCompletedHandler
    extends AbstractBaseResponseHandler
    implements EventResponseHandler {
        private WorkItemManager manager;
        private TaskClient client;

        public TaskCompletedHandler(WorkItemManager manager, TaskClient client) {
            this.manager = manager;
            this.client = client;
        }

        public void execute(Payload payload) {
            TaskEvent event = (TaskEvent)payload.get();
            long taskId = event.getTaskId();
            GetCompletedTaskResponseHandler getTaskResponseHandler = new GetCompletedTaskResponseHandler(this.manager, this.client);
            this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        }

        public boolean isRemove() {
            return false;
        }
    }

    private class TaskAddedHandler
    extends AbstractBaseResponseHandler
    implements TaskClientHandler.AddTaskResponseHandler {
        private long workItemId;
        private WorkItemManager manager;

        public TaskAddedHandler(WorkItemManager manager, long workItemId) {
            this.workItemId = workItemId;
            this.manager = manager;
        }

        public void execute(long taskId) {
        }

        public synchronized void setError(RuntimeException error) {
            super.setError(error);
            if (WSHumanTaskHandler.this.action.equals((Object)OnErrorAction.ABORT)) {
                this.manager.abortWorkItem(this.workItemId);
            } else {
                if (WSHumanTaskHandler.this.action.equals((Object)OnErrorAction.RETHROW)) {
                    throw this.getError();
                }
                if (WSHumanTaskHandler.this.action.equals((Object)OnErrorAction.LOG)) {
                    StringBuffer logMsg = new StringBuffer();
                    logMsg.append(new Date() + ": Error when creating task on task server for work item id " + this.workItemId);
                    logMsg.append(". Error reported by task server: " + this.getError().getMessage());
                    logger.error(logMsg.toString(), (Throwable)this.getError());
                }
            }
        }
    }
}

