/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.process.workitem.wsht.mina.sync;

import org.jbpm.process.workitem.wsht.MinaHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.sync.WSHumanTaskHandlerBaseSyncTest;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.mina.MinaTaskServer;

public class MinaHTWorkItemHandlerTest extends WSHumanTaskHandlerBaseSyncTest {

    private TaskServer server;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        server = new MinaTaskServer(taskService);
        System.out.println("Waiting for the Mina Server to come up");
        try {
            startTaskServerThread(server, false);
        } catch (Exception e) {
            startTaskServerThread(server, true);
        }
        
        MinaHTWorkItemHandler minaHTWorkItemHandler = new MinaHTWorkItemHandler(ksession);
        setClient(minaHTWorkItemHandler.getClient());
        setHandler(minaHTWorkItemHandler);
        
    }

    protected void tearDown() throws Exception {
        ((MinaHTWorkItemHandler) getHandler()).dispose();
        getClient().disconnect();
        server.stop();
        super.tearDown();
    }
}
