/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.ejb.impl.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.EJB;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.services.ejb.api.ExecutorServiceEJB;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.RequestInfoLogDeleteBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class BasicExecutorIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(BasicExecutorIntegrationTest.class);
    public static final Map<String, Object> cachedEntities = new HashMap<String, Object>();
    @EJB
    protected ExecutorServiceEJB executorService;
    @PersistenceUnit(unitName="org.jbpm.domain")
    protected EntityManagerFactory emf = null;

    @Deployment
    public static WebArchive createDeployment() {
        File archive = new File("target/executor-war-ejb-app.war");
        if (!archive.exists()) {
            throw new IllegalStateException("There is no archive yet generated, run maven build or mvn assembly:assembly");
        }
        WebArchive war = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)archive);
        war.addPackage("org.jbpm.executor.ejb.impl.test");
        return war;
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        this.executorService.clearAllRequests();
        this.executorService.clearAllErrors();
        System.clearProperty("org.kie.executor.msg.length");
        System.clearProperty("org.kie.executor.stacktrace.length");
    }

    @Test
    public void simpleExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", ctxCMD);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test
    public void callbackTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.ejb.impl.test.SimpleIncrementCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", commandContext);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addAnotherCallbackTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.ejb.impl.test.SimpleIncrementCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.ejb.impl.test.AddAnotherCallbackCommand", commandContext);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
        ExecutionResults results = null;
        byte[] responseData = ((RequestInfo)executedRequests.get(0)).getResponseData();
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(responseData));
            results = (ExecutionResults)in.readObject();
        }
        catch (Exception e) {
            logger.warn("Exception while serializing context data", (Throwable)e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String result = (String)results.getData("custom");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"custom callback invoked", (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleCallbackTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.ejb.impl.test.SimpleIncrementCallback, org.jbpm.executor.ejb.impl.test.CustomCallback");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", commandContext);
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
        Assert.assertEquals((long)2L, (long)((AtomicLong)cachedEntities.get((String)commandContext.getData("businessKey"))).longValue());
        ExecutionResults results = null;
        byte[] responseData = ((RequestInfo)executedRequests.get(0)).getResponseData();
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(responseData));
            results = (ExecutionResults)in.readObject();
        }
        catch (Exception e) {
            logger.warn("Exception while serializing context data", (Throwable)e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String result = (String)results.getData("custom");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"custom callback invoked", (Object)result);
    }

    @Test
    public void executorExceptionTest() throws InterruptedException {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.ejb.impl.test.SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executorService.scheduleRequest("org.jbpm.executor.ejb.impl.test.ThrowExceptionCommand", commandContext);
        logger.info("{} Sleeping for 10 secs", (Object)System.currentTimeMillis());
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        logger.info("Error: {}", inErrorRequests.get(0));
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
    }

    @Test
    public void defaultRequestRetryTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.ejb.impl.test.ThrowExceptionCommand", ctxCMD);
        Thread.sleep(12000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)4L, (long)errors.size());
    }

    @Test
    public void cancelRequestTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 5000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.PrintOutCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((RequestInfo)requests.get(0)).getId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }

    @Test
    public void executorExceptionTrimmingTest() throws InterruptedException {
        System.setProperty("org.kie.executor.msg.length", "10");
        System.setProperty("org.kie.executor.stacktrace.length", "20");
        CommandContext commandContext = new CommandContext();
        commandContext.setData("businessKey", (Object)UUID.randomUUID().toString());
        cachedEntities.put((String)commandContext.getData("businessKey"), new AtomicLong(1L));
        commandContext.setData("callbacks", (Object)"org.jbpm.executor.ejb.impl.test.SimpleIncrementCallback");
        commandContext.setData("retries", (Object)0);
        this.executorService.scheduleRequest("org.jbpm.executor.ejb.impl.test.ThrowExceptionCommand", commandContext);
        logger.info("{} Sleeping for 10 secs", (Object)System.currentTimeMillis());
        Thread.sleep(10000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)inErrorRequests.size());
        logger.info("Error: {}", inErrorRequests.get(0));
        List errors = this.executorService.getAllErrors(new QueryContext());
        logger.info("Errors: {}", (Object)errors);
        Assert.assertEquals((long)1L, (long)errors.size());
        ErrorInfo error = (ErrorInfo)errors.get(0);
        Assert.assertEquals((long)10L, (long)error.getMessage().length());
        Assert.assertEquals((long)20L, (long)error.getStacktrace().length());
    }

    @Test
    public void reoccurringExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        Thread.sleep(4000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)4L, (long)executedRequests.size());
    }

    @Test
    public void cleanupLogExcecutionTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.commands.ReoccurringPrintOutCommand", ctxCMD);
        Thread.sleep(3000L);
        List inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        List queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)queuedRequests.size());
        List executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)3L, (long)executedRequests.size());
        this.executorService.cancelRequest(Long.valueOf(requestId + 3L));
        List canceled = this.executorService.getCancelledRequests(new QueryContext());
        ExecutorJPAAuditService auditService = new ExecutorJPAAuditService(this.emf);
        int resultCount = ((RequestInfoLogDeleteBuilder)auditService.requestInfoLogDeleteBuilder().date(new Date[]{((RequestInfo)canceled.get(0)).getTime()})).status(new STATUS[]{STATUS.ERROR}).build().execute();
        Assert.assertEquals((long)0L, (long)resultCount);
        resultCount = ((ErrorInfoDeleteBuilder)auditService.errorInfoLogDeleteBuilder().date(new Date[]{((RequestInfo)canceled.get(0)).getTime()})).build().execute();
        Assert.assertEquals((long)0L, (long)resultCount);
        ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)UUID.randomUUID().toString());
        ctxCMD.setData("SingleRun", (Object)"true");
        ctxCMD.setData("EmfName", (Object)"org.jbpm.domain");
        ctxCMD.setData("SkipProcessLog", (Object)"true");
        ctxCMD.setData("SkipTaskLog", (Object)"true");
        this.executorService.scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", ctxCMD);
        Thread.sleep(5000L);
        inErrorRequests = this.executorService.getInErrorRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)inErrorRequests.size());
        queuedRequests = this.executorService.getQueuedRequests(new QueryContext());
        Assert.assertEquals((long)0L, (long)queuedRequests.size());
        executedRequests = this.executorService.getCompletedRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)executedRequests.size());
    }

    @Test
    public void cancelRequestWithSearchByCommandTest() throws InterruptedException {
        CommandContext ctxCMD = new CommandContext();
        String businessKey = UUID.randomUUID().toString();
        ctxCMD.setData("businessKey", (Object)businessKey);
        Date futureDate = new Date(System.currentTimeMillis() + 5000L);
        Long requestId = this.executorService.scheduleRequest("org.jbpm.executor.test.CustomCommand", futureDate, ctxCMD);
        List requests = this.executorService.getRequestsByCommand("org.jbpm.executor.test.CustomCommand", new QueryContext());
        Assert.assertNotNull((Object)requests);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)requestId, (Object)((RequestInfo)requests.get(0)).getId());
        this.executorService.cancelRequest(requestId);
        List cancelledRequests = this.executorService.getCancelledRequests(new QueryContext());
        Assert.assertEquals((long)1L, (long)cancelledRequests.size());
    }
}

