/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import io.vertx.core.json.JsonObject;
import java.io.File;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import org.jboss.windup.tooling.ExecutionBuilder;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.IProgressMonitorAdapter;
import org.jboss.windup.tooling.ProgressMonitorAdapter;
import org.jboss.windup.tooling.WindupToolingProgressMonitor;

public class ToolingModeRunner
implements IProgressMonitorAdapter {
    @Inject
    private ExecutionBuilder executionBuilder;
    private WindupToolingProgressMonitor progressMonitor = new ProgressMonitorAdapter(this);

    public void setProgressMonitor(WindupToolingProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public ExecutionResults run(Set<String> input, String output, boolean sourceMode, boolean skipReports, List<String> ignorePatterns, String windupHome, List<String> source, List<String> target, List<File> rulesDir, List<String> packages, List<String> excludePackages, Map<String, Object> options) {
        try {
            this.executionBuilder.setInput(input);
            this.executionBuilder.setOutput(output);
            this.executionBuilder.setOption("sourceMode", sourceMode);
            this.executionBuilder.setOption("skipReports", skipReports);
            Iterator<Object> iter = ignorePatterns.iterator();
            while (iter.hasNext()) {
                this.executionBuilder.ignore(iter.next());
            }
            this.executionBuilder.setWindupHome(windupHome);
            this.executionBuilder.setOption("source", source);
            this.executionBuilder.setOption("target", target);
            this.executionBuilder.setOption("userRulesDirectory", rulesDir);
            this.executionBuilder.setProgressMonitor(this.progressMonitor);
            this.executionBuilder.includePackages(packages);
            this.executionBuilder.excludePackages(excludePackages);
            for (Map.Entry entry : options.entrySet()) {
                this.executionBuilder.setOption((String)entry.getKey(), entry.getValue());
            }
            ExecutionResults results = this.executionBuilder.execute();
            results.serializeToXML(Paths.get(output + File.separatorChar + "results.xml", new String[0]));
            System.out.println(":progress: {\"op\":\"complete\"}");
            return results;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void log(String msg) {
        System.out.println(":progress: " + msg);
    }

    @Override
    public void beginTask(String task, int totalWork) {
        JsonObject load = new JsonObject();
        load.put("op", "beginTask");
        load.put("task", task);
        load.put("totalWork", Integer.valueOf(totalWork));
        this.log(load.toString());
    }

    @Override
    public void done() {
        JsonObject load = new JsonObject();
        load.put("op", "done");
        this.log(load.toString());
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void setCancelled(boolean value) {
    }

    @Override
    public void setTaskName(String name) {
        JsonObject load = new JsonObject();
        load.put("op", "setTaskName");
        load.put("value", name);
        this.log(load.toString());
    }

    @Override
    public void subTask(String name) {
        JsonObject load = new JsonObject();
        load.put("op", "subTask");
        load.put("value", name);
        this.log(load.toString());
    }

    @Override
    public void logMessage(LogRecord logRecord) {
        JsonObject load = new JsonObject();
        load.put("op", "logMessage");
        load.put("value", logRecord.getMessage());
        this.log(load.toString());
    }

    @Override
    public void worked(int work) {
        JsonObject load = new JsonObject();
        load.put("op", "worked");
        load.put("value", Integer.valueOf(work));
        this.log(load.toString());
    }
}

