/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.transformers;

import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.reporting.transformers.FileMetaTransformer;
import org.jboss.windup.reporting.transformers.MetaResultTransformer;
import org.springframework.beans.factory.InitializingBean;

public class MetaResultTransformResolver
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(MetaResultTransformResolver.class);
    private Map<String, MetaResultTransformer> transformResolver;
    private FileMetaTransformer defaultTransformer;
    private List<String> resolvers;

    public void setDefaultTransformer(FileMetaTransformer defaultTransformer) {
        this.defaultTransformer = defaultTransformer;
    }

    public MetaResultTransformer<?> resolveTransformer(String className) {
        if (this.transformResolver.containsKey(className)) {
            return this.transformResolver.get(className);
        }
        return this.defaultTransformer;
    }

    public MetaResultTransformer<?> resolveTransformer(Class className) {
        return this.resolveTransformer(className.toString());
    }

    public void setResolvers(List<String> resolvers) {
        this.resolvers = resolvers;
    }

    public void afterPropertiesSet() throws Exception {
        this.transformResolver = new HashMap<String, MetaResultTransformer>(this.resolvers.size());
        for (String clz : this.resolvers) {
            this.instantiateMapper(clz);
        }
    }

    private void instantiateMapper(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clz = Class.forName(className);
        MetaResultTransformer transformer = (MetaResultTransformer)clz.newInstance();
        String key = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments()[0].toString();
        this.transformResolver.put(key, transformer);
    }
}

