/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    private static final Log LOG = LogFactory.getLog(ReportUtil.class);

    public static String calculateRelativePathToRoot(File reportDirectory, File htmlOutputPath) {
        Validate.notNull((Object)reportDirectory, (String)"Report directory is null, but a required field.");
        Validate.notNull((Object)htmlOutputPath, (String)"HTML output directory is null, but a required field.");
        String archiveOutput = FilenameUtils.normalize((String)reportDirectory.getAbsolutePath());
        String htmlOutput = FilenameUtils.normalize((String)htmlOutputPath.getAbsolutePath());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("archiveOutput: " + archiveOutput));
            LOG.debug((Object)("htmlOutput: " + htmlOutput));
        }
        String relative = StringUtils.removeStart((String)htmlOutput, (String)archiveOutput);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        int dirCount = StringUtils.countMatches((String)relative, (String)"/") - 1;
        String relPath = "";
        for (int i = 0; i < dirCount; ++i) {
            relPath = relPath + "../";
        }
        return relPath;
    }

    public static String calculateRelativePathFromRoot(File reportDirectory, File relativeFile) {
        String relPath = StringUtils.removeStart((String)FilenameUtils.normalize((String)relativeFile.getAbsolutePath()), (String)FilenameUtils.normalize((String)reportDirectory.getAbsolutePath()));
        relPath = StringUtils.replace((String)relPath, (String)"\\", (String)"/");
        relPath = StringUtils.removeStart((String)relPath, (String)"/");
        return relPath;
    }
}

