/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.WindupEngine;
import org.jboss.windup.WindupEnvironment;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.reporting.Reporter;
import org.jboss.windup.util.RPMToZipTransformer;
import org.springframework.context.ApplicationContext;

public class ReportEngine {
    private static final String[] RPM_EXTENSIONS = new String[]{".rpm", ".rpm_"};
    private static final Log LOG = LogFactory.getLog(ReportEngine.class);
    private final Collection<Reporter> reporters;
    private final ApplicationContext context;
    private final WindupEngine windupEngine;
    private final WindupEnvironment settings;
    private final List<String> supportedExtensions;

    public ReportEngine(WindupEnvironment settings) {
        this(settings, new WindupEngine(settings));
    }

    public ReportEngine(WindupEnvironment settings, WindupEngine engine) {
        this.settings = settings;
        this.windupEngine = engine;
        this.context = this.windupEngine.getContext();
        this.reporters = (Collection)this.context.getBean("reporters");
        this.supportedExtensions = new ArrayList<String>((Collection)this.context.getBean("zipExtensions"));
    }

    public void process(File inputLocation, File outputLocation) throws IOException {
        if (!inputLocation.exists()) {
            throw new FileNotFoundException("Input file or directory not found: " + inputLocation);
        }
        if (this.settings.isSource()) {
            if (!inputLocation.isDirectory()) {
                throw new IllegalArgumentException("Source input must be a directory: " + inputLocation);
            }
            if (outputLocation == null) {
                String outputName = inputLocation.getName() + "-doc";
                String outputPathLoc = inputLocation.getParentFile().getAbsolutePath();
                outputPathLoc = outputPathLoc + File.separator + outputName;
                outputLocation = new File(outputPathLoc);
                LOG.info((Object)("Creating output path: " + outputLocation.getAbsolutePath()));
                LOG.info((Object)"  - To overwrite this in the future, use the -output parameter.");
            }
            if (!outputLocation.exists()) {
                FileUtils.forceMkdir((File)outputLocation);
            } else if (!outputLocation.isDirectory()) {
                throw new IllegalArgumentException("Output location already exists and is not a directory: " + outputLocation);
            }
            ArchiveMetadata am = this.windupEngine.processSourceDirectory(inputLocation, outputLocation);
            this.generateReport(am, outputLocation);
        } else {
            if (inputLocation.isDirectory()) {
                this.batchInputDirectory(inputLocation);
            } else {
                if (outputLocation == null) {
                    outputLocation = this.deduceArchiveOutputLocation(inputLocation);
                }
                ArchiveMetadata amd = this.windupEngine.processArchive(inputLocation, outputLocation);
                this.generateReport(amd, outputLocation);
            }
            LOG.info((Object)("Reporting complete for " + inputLocation.getPath()));
        }
    }

    protected File deduceArchiveOutputLocation(File input) throws IOException {
        String outputLoc = StringUtils.substringBeforeLast((String)input.getAbsolutePath(), (String)".");
        outputLoc = outputLoc + "-" + StringUtils.substringAfterLast((String)input.getAbsolutePath(), (String)".") + "-doc";
        File outputLocation = new File(outputLoc);
        FileUtils.forceMkdir((File)outputLocation);
        return outputLocation;
    }

    public Collection<ArchiveMetadata> batchInputDirectory(File dirPath) throws IOException {
        Validate.notNull((Object)dirPath, (String)"Directory Path is required, but null.");
        Validate.isTrue((boolean)dirPath.isDirectory(), (String)"Directory Path must be to directory.");
        LOG.info((Object)("Processing directory: " + dirPath.getAbsolutePath()));
        LinkedList<File> archives = new LinkedList<File>(Arrays.asList(dirPath.listFiles((FilenameFilter)new SuffixFileFilter(this.supportedExtensions))));
        File[] rpms = dirPath.listFiles((FilenameFilter)new SuffixFileFilter(RPM_EXTENSIONS));
        if (rpms.length > 0) {
            for (File rpm : rpms) {
                try {
                    File zip = RPMToZipTransformer.convertRpmToZip((File)rpm);
                    archives.add(zip);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Conversion of RPM: " + rpm.getAbsolutePath() + " to ZIP failed."));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Found " + archives.size() + " Archives"));
        }
        LinkedList<ArchiveMetadata> archiveMetas = new LinkedList<ArchiveMetadata>();
        for (File archive : archives) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing archive: " + archive.getAbsolutePath()));
            }
            LOG.info((Object)("ArchiveMetadata Path: " + archive.getAbsolutePath()));
            File output = this.deduceArchiveOutputLocation(archive);
            archiveMetas.add(this.windupEngine.processArchive(archive, output));
        }
        return archiveMetas;
    }

    protected void generateReport(ArchiveMetadata archive, File reportDirectory) {
        if (archive.getName() == null) {
            LOG.info((Object)("Processing reports for: " + archive.getFilePointer().toString()));
        } else {
            LOG.info((Object)("Processing reports for: " + archive.getName()));
        }
        if (this.reporters != null) {
            for (Reporter reporter : this.reporters) {
                reporter.process(archive, reportDirectory);
            }
        }
        if (this.reporters == null || this.reporters.size() == 0) {
            LOG.warn((Object)"No reporters are currently registered.");
        }
        LOG.info((Object)"Reporting complete.");
    }
}

