/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.bootstrap.commands.addons.AddAddonDirectoryCommand;
import org.jboss.windup.bootstrap.commands.addons.AddImmutableAddonDirectoryCommand;
import org.jboss.windup.bootstrap.commands.addons.InstallAddonCommand;
import org.jboss.windup.bootstrap.commands.addons.ListAddonsCommand;
import org.jboss.windup.bootstrap.commands.addons.RemoveAddonCommand;
import org.jboss.windup.bootstrap.commands.windup.DiscoverPackagesCommand;
import org.jboss.windup.bootstrap.commands.windup.DisplayHelpCommand;
import org.jboss.windup.bootstrap.commands.windup.DisplayVersionCommand;
import org.jboss.windup.bootstrap.commands.windup.GenerateCompletionDataCommand;
import org.jboss.windup.bootstrap.commands.windup.GenerateHelpCacheCommand;
import org.jboss.windup.bootstrap.commands.windup.ListSourceTechnologiesCommand;
import org.jboss.windup.bootstrap.commands.windup.ListTagsCommand;
import org.jboss.windup.bootstrap.commands.windup.ListTargetTechnologiesCommand;
import org.jboss.windup.bootstrap.commands.windup.RunWindupCommand;
import org.jboss.windup.bootstrap.commands.windup.ServerModeCommand;
import org.jboss.windup.bootstrap.commands.windup.ToolingModeCommand;
import org.jboss.windup.bootstrap.commands.windup.UpdateRulesetsCommand;
import org.jboss.windup.bootstrap.listener.ContainerStatusListener;
import org.jboss.windup.server.WindupServerProvider;
import org.jboss.windup.util.Theme;
import org.jboss.windup.util.ThemeProvider;

public class Bootstrap {
    public static final String WINDUP_HOME = "windup.home";
    private final AtomicBoolean batchMode = new AtomicBoolean(false);
    private final AtomicBoolean exitCodes = new AtomicBoolean(false);
    private Furnace furnace;
    private final ContainerStatusListener containerStatusListener = new ContainerStatusListener();

    public static void main(String[] args) {
        Bootstrap bootstrap;
        File runtimeLabelsDir;
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        for (String arg : args) {
            if (Bootstrap.handleAsSystemProperty(arg)) continue;
            bootstrapArgs.add(arg);
        }
        File rulesDir = Bootstrap.getUserRulesDir();
        if (!rulesDir.exists()) {
            rulesDir.mkdirs();
        }
        if (!(runtimeLabelsDir = Bootstrap.getUserRuntimeLabelsDir()).exists()) {
            runtimeLabelsDir.mkdirs();
        }
        String defaultLog = new File(Bootstrap.getUserWindupDir(), "log/windup.log").getAbsolutePath();
        String logDir = System.getProperty("org.jboss.forge.log.file", defaultLog);
        System.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
        }
        if (!(bootstrap = new Bootstrap()).serverMode(bootstrapArgs) && !bootstrap.toolingMode(bootstrapArgs)) {
            bootstrap.run(bootstrapArgs);
            bootstrap.stop();
        }
    }

    private static boolean handleAsSystemProperty(String argument) {
        String value;
        String name;
        if (!argument.startsWith("-D")) {
            return false;
        }
        int index = argument.indexOf(61);
        if (index == -1) {
            name = argument.substring(2);
            value = "true";
        } else {
            name = argument.substring(2, index);
            value = argument.substring(index + 1);
        }
        System.setProperty(name, value);
        return true;
    }

    private static boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String promptForListItem(String message, Collection<String> items, String defaultValue) {
        while (true) {
            String item2;
            ArrayList<String> sorted = new ArrayList<String>(items);
            Collections.sort(sorted);
            System.out.println();
            System.out.println(message);
            for (String item2 : sorted) {
                System.out.println("\t" + item2);
            }
            String promptMessage = "Please enter the item you would like to choose[" + defaultValue + "]: ";
            item2 = System.console().readLine(promptMessage, new Object[0]).trim();
            if (StringUtils.isNotBlank((CharSequence)item2)) {
                return item2;
            }
            if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                return defaultValue;
            }
            System.out.println("A selection is required. Please select one of the available items.");
        }
    }

    public static boolean prompt(String message, boolean defaultValue, boolean batchMode) {
        if (batchMode) {
            return defaultValue;
        }
        String defaultMessage = defaultValue ? " [Y,n] " : " [y,N] ";
        String line = System.console().readLine(message + defaultMessage, new Object[0]).trim();
        if ("y".equalsIgnoreCase(line)) {
            return true;
        }
        if ("n".equalsIgnoreCase(line)) {
            return false;
        }
        return defaultValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            if (stream == null) {
                String string = null;
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                    int i = line.indexOf(35);
                    if (i == -1) continue;
                    line = line.substring(0, i);
                } while ((line = line.trim()).length() == 0);
                String string = line;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getVersion() {
        return Bootstrap.getRuntimeAPIVersion().toString();
    }

    public static String getVersionString() {
        Theme theme = ThemeProvider.getInstance().getTheme();
        return String.format("> %s CLI %s (Windup Components %s) %s", theme.getBrandName(), theme.getCliVersion(), theme.getComponentsVersion(), theme.getBrandDocumentationUrl());
    }

    public static Version getRuntimeAPIVersion() {
        return SingleVersion.valueOf((String)ThemeProvider.getInstance().getTheme().getComponentsVersion());
    }

    private static File getUserRulesDir() {
        return new File(Bootstrap.getUserWindupDir(), "rules");
    }

    private static File getUserRuntimeLabelsDir() {
        return new File(Bootstrap.getUserWindupDir(), "labels");
    }

    public static File getUserWindupDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            Path path = new File("").toPath();
            return path.toFile();
        }
        return Paths.get(userHome, new String[0]).resolve(".windup").toFile();
    }

    private static File getUserAddonsDir() {
        return Bootstrap.getUserWindupDir().toPath().resolve(".addons").toFile();
    }

    private boolean serverMode(List<String> arguments) {
        if (ServerModeCommand.isServerMode(arguments)) {
            ServerModeCommand serverCommand = new ServerModeCommand(arguments);
            serverCommand.execute();
            return true;
        }
        return false;
    }

    private void run(List<String> args) {
        Theme theme = ThemeProvider.getInstance().getTheme();
        try {
            this.furnace = FurnaceFactory.getInstance();
            this.furnace.setServerMode(true);
            CopyOnWriteArrayList<Command> commands = new CopyOnWriteArrayList<Command>(this.processArguments(args));
            if (!this.executePhase(CommandPhase.PRE_CONFIGURATION, commands)) {
                return;
            }
            if (!this.executePhase(CommandPhase.CONFIGURATION, commands)) {
                return;
            }
            if (commands.isEmpty()) {
                new DisplayHelpCommand().execute();
                return;
            }
            if (!Bootstrap.containsMutableRepository(this.furnace.getRepositories())) {
                this.furnace.addRepository(AddonRepositoryMode.MUTABLE, Bootstrap.getUserAddonsDir());
            }
            if (!this.executePhase(CommandPhase.POST_CONFIGURATION, commands) || commands.isEmpty()) {
                return;
            }
            this.furnace.addContainerLifecycleListener((ContainerLifecycleListener)this.containerStatusListener);
            try {
                this.startFurnace();
            }
            catch (Exception e) {
                System.out.println("Failed to start " + theme.getBrandNameAcronym() + "!");
                if (e.getMessage() != null) {
                    System.out.println("Failure reason: " + e.getMessage());
                }
                e.printStackTrace();
            }
            if (!this.executePhase(CommandPhase.PRE_EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
            Imported serverProviders = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupServerProvider.class);
            for (WindupServerProvider serverProvider : serverProviders) {
                String expectedArgName = serverProvider.getName();
                boolean matches = args.stream().anyMatch(arg -> arg.equals(expectedArgName) || arg.equals("--" + expectedArgName));
                if (!matches) continue;
                serverProvider.runServer(args.toArray(new String[args.size()]));
                return;
            }
            if (!this.executePhase(CommandPhase.EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
            if (!this.executePhase(CommandPhase.POST_EXECUTION, commands) || commands.isEmpty()) {
                return;
            }
        }
        catch (Throwable t) {
            System.err.println(theme.getBrandNameAcronym() + " execution failed due to: " + t.getMessage());
            t.printStackTrace();
            System.exit(-1);
        }
    }

    private void startFurnace() throws InterruptedException, ExecutionException {
        block3: {
            long timeWaited;
            Future future = this.furnace.startAsync();
            future.get();
            long startTime = System.currentTimeMillis();
            long maxWait = 30000L;
            do {
                long currentTime = System.currentTimeMillis();
                timeWaited = currentTime - startTime;
                boolean allStarted = true;
                for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons()) {
                    if (addon.getStatus().isStarted()) continue;
                    allStarted = false;
                }
                if (allStarted) break block3;
            } while (timeWaited <= maxWait);
            System.err.println("WARN: Not all addons started!");
            for (Addon addon : this.furnace.getAddonRegistry(new AddonRepository[0]).getAddons()) {
                if (addon.getStatus().isStarted()) continue;
                System.err.println("WARN: " + addon.getId() + " status: " + addon.getStatus());
            }
        }
    }

    private void stop() {
        if (this.furnace != null && !this.furnace.getStatus().isStopped()) {
            this.furnace.stop();
        }
        while (!this.containerStatusListener.getContainerStatus().isStopped()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                System.err.println("Failure waiting for Furnace to shutdown: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private List<Command> processArguments(List<String> arguments) {
        ArrayList<String> windupArguments;
        ArrayList<String> unknownArgs = new ArrayList<String>();
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean versionCommandAdded = false;
        for (int i = 0; i < arguments.size(); ++i) {
            String arg = arguments.get(i);
            if ("--batchMode".equals(arg) || "-b".equals(arg)) {
                this.batchMode.set(true);
                continue;
            }
            if ("--exitCodes".equals(arg) || "-e".equals(arg)) {
                this.exitCodes.set(true);
                continue;
            }
            if ("--debug".equals(arg) || "-d".equals(arg)) continue;
            if (arg.equals("-help") || arg.equals("--help") || arg.equals("-h") || arg.equals("/?") || arg.equals("/help")) {
                commands.add(new DisplayHelpCommand());
                continue;
            }
            if ("--install".equals(arg) || "-i".equals(arg)) {
                commands.add(new InstallAddonCommand(arguments.get(++i), this.batchMode));
                continue;
            }
            if ("--remove".equals(arg) || "-r".equals(arg)) {
                commands.add(new RemoveAddonCommand(arguments.get(++i), this.batchMode));
                continue;
            }
            if ("--list".equals(arg) || "-l".equals(arg)) {
                commands.add(new ListAddonsCommand());
                continue;
            }
            if ("--addonDir".equals(arg) || "-a".equals(arg)) {
                commands.add(new AddAddonDirectoryCommand(arguments.get(++i)));
                continue;
            }
            if ("--immutableAddonDir".equals(arg) || "-m".equals(arg)) {
                commands.add(new AddImmutableAddonDirectoryCommand(arguments.get(++i)));
                continue;
            }
            if ("--version".equals(arg) || "-v".equals(arg)) {
                versionCommandAdded = true;
                commands.add(new DisplayVersionCommand());
                continue;
            }
            if ("--listTags".equals(arg)) {
                commands.add(new ListTagsCommand(arguments));
                continue;
            }
            if ("--listSourceTechnologies".equals(arg)) {
                commands.add(new ListSourceTechnologiesCommand(arguments));
                continue;
            }
            if ("--listTargetTechnologies".equals(arg)) {
                commands.add(new ListTargetTechnologiesCommand(arguments));
                continue;
            }
            if ("--generateCompletionData".equals(arg)) {
                commands.add(new GenerateCompletionDataCommand(true));
                continue;
            }
            if (arg.equals("--generateHelp")) {
                commands.add(new GenerateHelpCacheCommand());
                continue;
            }
            if ("--generateCaches".equals(arg)) {
                commands.add(new GenerateCompletionDataCommand(true));
                commands.add(new GenerateHelpCacheCommand());
                continue;
            }
            if ("--discoverPackages".equals(arg)) {
                unknownArgs.add(arg);
                commands.add(new DiscoverPackagesCommand(unknownArgs));
                continue;
            }
            if (arg.startsWith("--updateRules")) {
                commands.add(new UpdateRulesetsCommand());
                continue;
            }
            unknownArgs.add(arg);
        }
        if (!versionCommandAdded) {
            commands.add(0, new DisplayVersionCommand(CommandResult.CONTINUE));
        }
        if (!(windupArguments = new ArrayList<String>(unknownArgs)).isEmpty()) {
            commands.add(new GenerateHelpCacheCommand());
            commands.add(new GenerateCompletionDataCommand(true));
            commands.add(new RunWindupCommand(windupArguments, this.batchMode, this.exitCodes));
        }
        return commands;
    }

    private boolean executePhase(CommandPhase phase, CopyOnWriteArrayList<Command> commands) {
        for (Command command : commands) {
            CommandResult result;
            if (!phase.equals((Object)command.getPhase())) continue;
            commands.remove(command);
            if (command instanceof FurnaceDependent) {
                ((FurnaceDependent)((Object)command)).setFurnace(this.furnace);
            }
            if (!CommandResult.EXIT.equals((Object)(result = command.execute()))) continue;
            return false;
        }
        return true;
    }

    private boolean toolingMode(List<String> arguments) {
        if (ToolingModeCommand.isToolingMode(arguments)) {
            ToolingModeCommand toolingCommand = new ToolingModeCommand(arguments);
            toolingCommand.execute();
            return true;
        }
        return false;
    }
}

