/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.bootstrap.commands.AbstractListCommand;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMappingRegistry;
import org.jboss.windup.util.ClassNameUtil;
import org.jboss.windup.util.PackageComparator;
import org.jboss.windup.util.PackageFrequencyTrie;
import org.jboss.windup.util.PackageFrequencyTrieVisitor;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ZipUtil;

public class DiscoverPackagesCommand
extends AbstractListCommand
implements Command,
FurnaceDependent {
    private final List<String> arguments;

    public DiscoverPackagesCommand(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public CommandResult execute() {
        String input = null;
        for (int i = 0; i < this.arguments.size(); ++i) {
            String argument = this.arguments.get(i);
            if (!argument.equalsIgnoreCase("--input") || this.arguments.size() <= i + 1) continue;
            input = this.arguments.get(i + 1);
            break;
        }
        if (input == null) {
            System.err.println();
            System.err.println("ERROR: --input must be specified");
            return CommandResult.EXIT;
        }
        Path inputPath = Paths.get(input, new String[0]);
        if (!Files.isDirectory(inputPath, new LinkOption[0]) && !Files.isRegularFile(inputPath, new LinkOption[0])) {
            System.err.println();
            System.err.println("ERROR: --input must exist");
            return CommandResult.EXIT;
        }
        if (Files.isRegularFile(inputPath, new LinkOption[0]) && !Files.isReadable(inputPath)) {
            System.err.println();
            System.err.println("ERROR: --input must be readable");
            return CommandResult.EXIT;
        }
        Map<String, Integer> classes = DiscoverPackagesCommand.findClasses(Paths.get(input, new String[0]));
        PackageNameMappingRegistry packageNameMappingRegistry = (PackageNameMappingRegistry)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(PackageNameMappingRegistry.class).get();
        packageNameMappingRegistry.loadPackageMappings();
        TreeMap<String, String> packageToOrganization = new TreeMap<String, String>((Comparator<String>)new PackageComparator());
        PackageFrequencyTrie frequencyTrie = new PackageFrequencyTrie();
        for (String string : classes.keySet()) {
            String packageName = ClassNameUtil.getPackageName((String)string);
            String organization = packageNameMappingRegistry.getOrganizationForPackage(packageName);
            if (organization == null) {
                frequencyTrie.addClass(string);
                continue;
            }
            packageToOrganization.put(packageName, organization);
        }
        System.out.println("Known Packages:");
        System.out.println("=======================");
        System.out.println();
        for (Map.Entry entry : packageToOrganization.entrySet()) {
            System.out.println((String)entry.getKey() + " - " + (String)entry.getValue());
        }
        System.out.println();
        System.out.println("Unknown Packages:");
        System.out.println("=======================");
        frequencyTrie.visit(new PackageFrequencyTrieVisitor(){

            public void visit(PackageFrequencyTrie trie, int depth) {
                String packageName = trie.getPackageName();
                int recursiveClassCount = trie.getClassCount(true);
                if (depth == 1 || depth > 1 && recursiveClassCount > 100) {
                    System.out.println(packageName + " - Classes: " + recursiveClassCount);
                }
                if (depth == 0 && trie.getClassCount(false) > 0) {
                    System.out.println("Default Package - Classes: " + trie.getClassCount(false));
                }
            }
        });
        return CommandResult.EXIT;
    }

    @Override
    public CommandPhase getPhase() {
        return CommandPhase.PRE_EXECUTION;
    }

    private static Map<String, Integer> findClasses(Path path) {
        List<String> paths = DiscoverPackagesCommand.findPaths(path, true);
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String subPath : paths) {
            if (!subPath.endsWith(".java") && !subPath.endsWith(".class")) continue;
            String qualifiedName = PathUtil.classFilePathToClassname((String)subPath);
            DiscoverPackagesCommand.addClassToMap(results, qualifiedName);
        }
        return results;
    }

    private static void addClassToMap(Map<String, Integer> map, String className) {
        Integer count = map.get(className);
        if (count == null) {
            map.put(className, 1);
        } else {
            map.put(className, count + 1);
        }
    }

    private static Collection<String> findPaths(Path path) {
        List<String> paths = DiscoverPackagesCommand.findPaths(path, false);
        Collections.sort(paths);
        return paths;
    }

    private static List<String> findPaths(Path path, boolean relativeOnly) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(path.normalize().toAbsolutePath().toString());
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path child : directoryStream) {
                    results.addAll(DiscoverPackagesCommand.findPaths(child, relativeOnly));
                }
            }
            catch (IOException e) {
                System.err.println("Could not read file: " + path + " due to: " + e.getMessage());
            }
        } else if (Files.isRegularFile(path, new LinkOption[0]) && ZipUtil.endsWithZipExtension((String)path.toString())) {
            results.addAll(ZipUtil.scanZipFile((Path)path, (boolean)relativeOnly));
        }
        return results;
    }
}

