/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.addons.AddImmutableAddonDirectoryCommand;
import org.jboss.windup.tooling.ToolingModeRunner;
import org.jboss.windup.util.Theme;
import org.jboss.windup.util.ThemeProvider;

public class ToolingModeCommand
implements Command {
    public static final String COMMAND_ID = "--toolingMode";
    private Furnace furnace;
    private List<String> arguments;
    private String addonsDirectory;

    public ToolingModeCommand(List<String> arguments) {
        this.arguments = arguments;
        this.addonsDirectory = ToolingModeCommand.getAddonDirectory(arguments);
    }

    private static String getAddonDirectory(List<String> arguments) {
        int index = arguments.indexOf("--immutableAddonDir");
        if (index == -1) {
            return "";
        }
        return arguments.get(++index);
    }

    @Override
    public CommandResult execute() {
        Theme theme = ThemeProvider.getInstance().getTheme();
        try {
            this.furnace = FurnaceFactory.getInstance();
            this.furnace.setServerMode(true);
            this.loadAddons();
            try {
                Future future = this.furnace.startAsync();
                future.get();
            }
            catch (Exception e) {
                System.out.println("Failed to start " + theme.getBrandNameAcronym() + "!");
                e.printStackTrace();
            }
            this.analyze();
            this.furnace.stop();
        }
        catch (Throwable t) {
            System.err.println(theme.getBrandNameAcronym() + " execution failed due to: " + t.getMessage());
            t.printStackTrace();
        }
        return null;
    }

    private void loadAddons() {
        AddImmutableAddonDirectoryCommand addonCommand = new AddImmutableAddonDirectoryCommand(this.addonsDirectory);
        addonCommand.setFurnace(this.furnace);
        addonCommand.execute();
    }

    private void analyze() {
        System.out.println("Calling ToolingModeRunner...");
        Set<String> input = this.getInput();
        String output = this.getOutput();
        boolean sourceMode = this.isSourceMode();
        boolean ignoreReport = this.ignoreReport();
        List<String> ignorePatterns = this.getIgnorePatterns();
        String windupHome = this.getWindupHome();
        List<String> source = this.getSource();
        List<String> target = this.getTarget();
        List<File> rulesDir = this.getUserRulesDir();
        List<String> packages = this.getPackages();
        List<String> excludePackage = this.getExcludePackages();
        Map<String, Object> options = this.collectOptions();
        if (input.isEmpty()) {
            System.out.println("Error - `input` required");
            return;
        }
        if (output == null) {
            System.out.println("Error - `output` required");
            return;
        }
        if (windupHome == null) {
            System.out.println("Error - `windupHome` required");
            return;
        }
        if (target.isEmpty()) {
            System.out.println("Error - `target` required");
            return;
        }
        System.out.println("Using Data: ");
        System.out.println("input: " + input);
        System.out.println("output: " + output);
        System.out.println("sourceMode: " + sourceMode);
        System.out.println("skipReport: " + ignoreReport);
        System.out.println("ignorePatterns: " + ignorePatterns);
        System.out.println("windupHome: " + windupHome);
        System.out.println("source: " + source);
        System.out.println("target: " + target);
        System.out.println("userRulesDirectory: " + rulesDir);
        ((ToolingModeRunner)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(ToolingModeRunner.class).get()).run(input, output, sourceMode, ignoreReport, ignorePatterns, windupHome, source, target, rulesDir, packages, excludePackage, options);
    }

    public Map<String, Object> collectOptions() {
        List<File> additionalClasspath;
        HashMap<String, Object> options = new HashMap<String, Object>();
        String userIgnorePath = this.getUserIgnorePath();
        if (userIgnorePath != null) {
            options.put("userIgnorePath", userIgnorePath);
        }
        options.put("overwrite", this.overwrite());
        String mavenizeGroupId = this.getMavenizeGroupId();
        if (mavenizeGroupId != null) {
            options.put("mavenizeGroupId", mavenizeGroupId);
        }
        options.put("exportCSV", this.exportCSV());
        List<String> excludeTags = this.getExcludeTags();
        if (!excludeTags.isEmpty()) {
            options.put("excludeTags", excludeTags);
        }
        if (!(additionalClasspath = this.getAdditionalClasspath()).isEmpty()) {
            options.put("additionalClasspath", additionalClasspath);
        }
        options.put("disableTattletale", this.disableTattletale());
        options.put("enableCompatibleFilesReport", this.enableCompatibleFilesReport());
        List<String> includeTags = this.getIncludeTags();
        if (!includeTags.isEmpty()) {
            options.put("includeTags", includeTags);
        }
        options.put("online", this.online());
        options.put("enableClassNotFoundAnalysis", this.enableClassNotFoundAnalysis());
        options.put("enableTattletale", this.enableTattletale());
        options.put("explodedApp", this.explodedApp());
        options.put("keepWorkDirs", this.keepWorkDirs());
        options.put("mavenize", this.mavenize());
        String inputApplicationName = this.getInputApplicationName();
        if (inputApplicationName != null) {
            options.put("inputApplicationName", inputApplicationName);
        }
        return options;
    }

    @Override
    public CommandPhase getPhase() {
        return null;
    }

    public static boolean isToolingMode(List<String> arguments) {
        return arguments.contains(COMMAND_ID);
    }

    public Set<String> getInput() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("input")) + 1;
        return Sets.toSet(this.getValues(index));
    }

    private String getOutput() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("output")) + 1;
        List<String> values = this.getValues(index);
        return values.size() == 1 ? values.get(0) : null;
    }

    private boolean isSourceMode() {
        return this.arguments.contains(ToolingModeCommand.toArg("sourceMode"));
    }

    private boolean ignoreReport() {
        return this.arguments.contains(ToolingModeCommand.toArg("skipReports"));
    }

    private List<String> getIgnorePatterns() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("ignorePattern")) + 1;
        return this.getValues(index);
    }

    private String getWindupHome() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("windupHome")) + 1;
        List<String> values = this.getValues(index);
        return values.size() == 1 ? values.get(0) : null;
    }

    private List<String> getSource() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("source")) + 1;
        return this.getValues(index);
    }

    private List<String> getTarget() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("target")) + 1;
        return this.getValues(index);
    }

    private List<File> getUserRulesDir() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("userRulesDirectory")) + 1;
        ArrayList rules = Lists.newArrayList();
        List<String> values = this.getValues(index);
        values.forEach(value -> rules.add(new File((String)value)));
        return rules;
    }

    private String getUserIgnorePath() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("userIgnorePath")) + 1;
        List<String> values = this.getValues(index);
        return values.size() == 1 ? values.get(0) : null;
    }

    private boolean overwrite() {
        return this.arguments.contains(ToolingModeCommand.toArg("overwrite"));
    }

    public List<String> getExcludePackages() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("excludePackages")) + 1;
        return this.getValues(index);
    }

    private String getMavenizeGroupId() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("mavenizeGroupId")) + 1;
        List<String> values = this.getValues(index);
        return values.size() == 1 ? values.get(0) : null;
    }

    private boolean exportCSV() {
        return this.arguments.contains(ToolingModeCommand.toArg("exportCSV"));
    }

    private List<String> getExcludeTags() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("excludeTags")) + 1;
        return this.getValues(index);
    }

    public List<String> getPackages() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("packages")) + 1;
        return this.getValues(index);
    }

    private List<File> getAdditionalClasspath() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("additionalClasspath")) + 1;
        ArrayList locations = Lists.newArrayList();
        List<String> values = this.getValues(index);
        values.forEach(value -> locations.add(new File((String)value)));
        return locations;
    }

    private boolean disableTattletale() {
        return this.arguments.contains(ToolingModeCommand.toArg("disableTattletale"));
    }

    private boolean enableCompatibleFilesReport() {
        return this.arguments.contains(ToolingModeCommand.toArg("enableCompatibleFilesReport"));
    }

    private List<String> getIncludeTags() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("includeTags")) + 1;
        return this.getValues(index);
    }

    private boolean online() {
        return this.arguments.contains(ToolingModeCommand.toArg("online"));
    }

    private boolean enableClassNotFoundAnalysis() {
        return this.arguments.contains(ToolingModeCommand.toArg("enableClassNotFoundAnalysis"));
    }

    private boolean enableTattletale() {
        return this.arguments.contains(ToolingModeCommand.toArg("enableTattletale"));
    }

    private boolean explodedApp() {
        return this.arguments.contains(ToolingModeCommand.toArg("explodedApp"));
    }

    private boolean keepWorkDirs() {
        return this.arguments.contains(ToolingModeCommand.toArg("keepWorkDirs"));
    }

    private boolean mavenize() {
        return this.arguments.contains(ToolingModeCommand.toArg("mavenize"));
    }

    private String getInputApplicationName() {
        int index = this.arguments.indexOf(ToolingModeCommand.toArg("inputApplicationName")) + 1;
        List<String> values = this.getValues(index);
        return values.size() == 1 ? values.get(0) : null;
    }

    private static String toArg(String name) {
        return "--" + name;
    }

    private List<String> getValues(int index) {
        String arg;
        ArrayList values = Lists.newArrayList();
        if (index == 0) {
            return values;
        }
        while (index < this.arguments.size() && !(arg = this.arguments.get(index)).contains("--")) {
            values.add(arg.replace("\"", ""));
            ++index;
        }
        return values;
    }
}

