/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.windup.bootstrap.Theme;

public class ThemeProvider {
    private static volatile ThemeProvider instance;
    private final Theme theme;

    private ThemeProvider() {
        try (InputStream input = ThemeProvider.class.getClassLoader().getResourceAsStream("windup-config.properties");){
            Properties prop = new Properties();
            prop.load(input);
            String brandName = prop.getProperty("distributionBrandName");
            String nameAcronym = prop.getProperty("distributionBrandNameAcronym");
            String documentationUrl = prop.getProperty("distributionBrandDocumentationUrl");
            String cliName = prop.getProperty("distributionBrandCliName");
            this.theme = new Theme(brandName, nameAcronym, documentationUrl, cliName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThemeProvider getInstance() {
        if (instance != null) return instance;
        Class<ThemeProvider> clazz = ThemeProvider.class;
        synchronized (ThemeProvider.class) {
            if (instance != null) return instance;
            instance = new ThemeProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Theme getTheme() {
        return this.theme;
    }
}

