/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;

public class InputsHandler {
    private static final Logger LOG = Logger.getLogger(InputsHandler.class.getName());

    public List<Path> handle(List<Path> inputs) {
        if (inputs.size() == 0) {
            throw new WindupException("No inputs found. At least one input must be specified.");
        }
        if (inputs.size() == 1) {
            Path path = inputs.get(0);
            if (this.containsArchives(path)) {
                LinkedList<Path> linkedList;
                block12: {
                    LinkedList<Path> archives = new LinkedList<Path>();
                    DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                    try {
                        for (Path subpath : directoryStream) {
                            if (!InputsHandler.isJavaArchive(subpath)) continue;
                            archives.add(subpath);
                        }
                        linkedList = archives;
                        if (directoryStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (directoryStream != null) {
                                try {
                                    directoryStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new WindupException("Failed to read directory contents of: " + path + ": " + e.getMessage());
                        }
                    }
                    directoryStream.close();
                }
                return linkedList;
            }
            return inputs;
        }
        return inputs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsArchives(Path path) {
        if (InputsHandler.isJavaArchive(path)) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            Path subpath;
            Iterator<Path> iterator = directoryStream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!InputsHandler.isJavaArchive(subpath = iterator.next()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new WindupException("Failed to read directory contents of: " + path + ": " + e.getMessage());
        }
    }

    private static boolean isJavaArchive(Path path) {
        return ZipUtil.endsWithZipExtension((String)path.toString());
    }
}

