/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.janusgraph.core.JanusGraphException;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.bootstrap.Bootstrap;
import org.jboss.windup.bootstrap.ConsoleProgressMonitor;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.bootstrap.commands.windup.InputsHandler;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.exec.Util;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.configuration.options.OutputPathOption;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;

public class RunWindupCommand
implements Command,
FurnaceDependent {
    private static final Logger log = Logging.get(RunWindupCommand.class);
    private Furnace furnace;
    private final List<String> arguments;
    private final AtomicBoolean batchMode;
    private final AtomicBoolean exitCodes;

    public RunWindupCommand(List<String> arguments, AtomicBoolean batchMode, AtomicBoolean exitCodes) {
        this.arguments = arguments;
        this.batchMode = batchMode;
        this.exitCodes = exitCodes;
    }

    @Override
    public CommandResult execute() {
        int returnCode = this.runWindup(this.arguments);
        if (returnCode != 0 && this.exitCodes.get()) {
            System.exit(returnCode);
        }
        return CommandResult.EXIT;
    }

    @Override
    public void setFurnace(Furnace furnace) {
        this.furnace = furnace;
    }

    @Override
    public CommandPhase getPhase() {
        return CommandPhase.EXECUTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runWindup(List<String> arguments) {
        Object promptMsg;
        boolean validationSuccess;
        Set<String> targets;
        Iterable optionIterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnace);
        HashMap<String, ConfigurationOption> options = new HashMap<String, ConfigurationOption>();
        for (ConfigurationOption option : optionIterable) {
            options.put(option.getName().toUpperCase(), option);
        }
        HashMap<String, Object> optionValues = new HashMap<String, Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            String valueString;
            String argument = arguments.get(i);
            String optionName = this.getOptionName(argument);
            if (optionName == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            ConfigurationOption option = (ConfigurationOption)options.get(optionName.toUpperCase());
            if (option == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                if (options.size() != 0) continue;
                System.err.println("FATAL: Furnace Addon repository path: " + System.lineSeparator() + this.furnace.getAddonRegistry(new AddonRepository[0]).toString());
                continue;
            }
            if (option.getUIType() == InputType.MANY || option.getUIType() == InputType.SELECT_MANY) {
                ArrayList<Object> values = new ArrayList<Object>();
                ++i;
                while (i < arguments.size()) {
                    String arg = arguments.get(i);
                    String name = this.getOptionName(arg);
                    if (name != null) {
                        --i;
                        break;
                    }
                    String valueString2 = arguments.get(i);
                    if (!StringUtils.isBlank((CharSequence)valueString2)) {
                        values.add(this.convertType(option.getType(), StringUtils.trim((String)valueString2)));
                    }
                    ++i;
                }
                if (optionValues.containsKey(option.getName())) {
                    ((List)optionValues.get(option.getName())).addAll(values);
                    continue;
                }
                optionValues.put(option.getName(), values);
                continue;
            }
            if (Boolean.class.isAssignableFrom(option.getType())) {
                optionValues.put(option.getName(), true);
                continue;
            }
            String string = valueString = arguments.size() > i + 1 ? arguments.get(++i) : null;
            if (this.getOptionName(valueString) != null) {
                --i;
                valueString = "";
            }
            Object value = this.convertType(option.getType(), valueString);
            optionValues.put(option.getName(), value);
        }
        this.setDefaultOutputPath(optionValues);
        this.setDefaultOptionsValues(options, optionValues);
        RuleProviderRegistryCache ruleProviderRegistryCache = (RuleProviderRegistryCache)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(RuleProviderRegistryCache.class).get();
        Iterable userProvidedPaths = (Iterable)optionValues.get("userRulesDirectory");
        if (userProvidedPaths != null) {
            for (File userProvidedPath : userProvidedPaths) {
                ruleProviderRegistryCache.addUserRulesPath(userProvidedPath.toPath());
            }
        }
        if ((targets = (Set<String>)optionValues.get("target")) != null && targets.contains("eap")) {
            System.err.println("ERROR: Version must be specified for target 'eap' (for example, 'eap7' or 'eap8')");
            return 1;
        }
        if ((targets == null || targets.isEmpty()) && !this.batchMode.get()) {
            String target2 = Bootstrap.promptForListItem("Please select a target:", ruleProviderRegistryCache.getAvailableTargetTechnologies(), "eap7");
            targets = Collections.singleton(target2);
            optionValues.put("target", targets);
        }
        if (!(validationSuccess = this.validateOptionValues(options, optionValues))) {
            return 1;
        }
        boolean eapTarget = targets.stream().anyMatch(target -> target.startsWith("eap"));
        boolean disableReport = false;
        if (optionValues.containsKey("disableTattletale")) {
            disableReport = (Boolean)optionValues.get("disableTattletale");
        }
        boolean enableReport = false;
        if (optionValues.containsKey("enableTattletale")) {
            enableReport = (Boolean)optionValues.get("enableTattletale");
        }
        if (disableReport && enableReport) {
            System.out.println("INFO: --disableTattletale option ignored since --enableTattletale option has been provided as well.");
        } else if (eapTarget) {
            if (enableReport) {
                System.out.println("INFO: --enableTattletale option can be removed since Tattletale report generation is enabled by default when JBoss EAP is one of the analysis targets.");
            }
        } else if (disableReport) {
            System.out.println("INFO: --disableTattletale option can be removed since Tattletale report generation is not enabled by default when JBoss EAP is not one of the analysis targets.");
        }
        boolean isExplodedApp = false;
        if (optionValues.containsKey("explodedApp")) {
            isExplodedApp = (Boolean)optionValues.get("explodedApp");
        }
        if (optionValues.containsKey("sourceMode")) {
            boolean bl = isExplodedApp = isExplodedApp || (Boolean)optionValues.get("sourceMode") != false;
        }
        if (!isExplodedApp) {
            List<Path> input = (List<Path>)optionValues.get("input");
            input = new InputsHandler().handle(input);
            optionValues.put("input", input);
        }
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (Map.Entry optionEntry : options.entrySet()) {
            ConfigurationOption option = (ConfigurationOption)optionEntry.getValue();
            windupConfiguration.setOptionValue(option.getName(), optionValues.get(option.getName()));
        }
        if (!this.validateInputAndOutputPath(windupConfiguration.getInputPaths(), windupConfiguration.getOutputDirectory())) {
            return 1;
        }
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to create default directories due to: " + e.getMessage());
            return 1;
        }
        Boolean overwrite = (Boolean)windupConfiguration.getOptionMap().get("overwrite");
        if (overwrite == null) {
            overwrite = false;
        }
        if (!overwrite.booleanValue() && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile()) && !Bootstrap.prompt((String)(promptMsg = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?"), false, this.batchMode.get())) {
            String outputPath = windupConfiguration.getOutputDirectory().toString();
            System.err.println("Files exist in " + outputPath + ", but --overwrite not specified. Aborting!");
            return 1;
        }
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        System.out.println();
        if (windupConfiguration.getInputPaths().size() == 1) {
            System.out.println("Input Application:" + windupConfiguration.getInputPaths().iterator().next());
        } else {
            System.out.println("Input Applications:");
            for (Path inputPath : windupConfiguration.getInputPaths()) {
                System.out.println("\t" + inputPath);
            }
            System.out.println();
        }
        System.out.println("Output Path:" + windupConfiguration.getOutputDirectory());
        System.out.println();
        this.normalizePackagePrefixes(windupConfiguration);
        try {
            ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor);
            this.getWindupProcessor().execute(windupConfiguration);
            Boolean skipReports = (Boolean)windupConfiguration.getOptionMap().get("skipReports");
            if (!skipReports.booleanValue()) {
                Path indexHtmlPath = windupConfiguration.getOutputDirectory().resolve("index.html").normalize().toAbsolutePath();
                System.out.println("Report created: " + indexHtmlPath + System.getProperty("line.separator") + "              Access it at this URL: " + indexHtmlPath.toUri());
            } else {
                System.out.println("Generating reports were disabled by option --skipReports");
                System.out.println("If using that option was unintentional, please run Windup again to generate reports.");
            }
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null && JanusGraphException.class.getName().equals(Proxies.unwrap((Object)e).getClass().getName()) && "com.sleepycat.je.DiskLimitException".equals(rootCause.getClass().getName())) {
                System.err.printf("Execution failed due to disk space issue in the output path. Please check the field 'freeDiskLimit' in the next message: it represents the minimum free space required (in bytes)%n%s%n", ExceptionUtils.getRootCause((Throwable)e).getMessage());
            } else {
                System.err.println("Execution failed due to: " + e.getMessage());
            }
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            Util.deleteGraphDataUnlessInhibited((WindupConfiguration)windupConfiguration, (Path)windupConfiguration.getOutputDirectory().resolve("graph"));
        }
        return 0;
    }

    private boolean validateInputAndOutputPath(Collection<Path> inputPaths, Path outputPath) {
        ValidationResult validationResult = OutputPathOption.validateInputsAndOutputPaths(inputPaths, (Path)outputPath);
        switch (validationResult.getLevel()) {
            case ERROR: {
                System.err.println("ERROR: " + validationResult.getMessage());
                return false;
            }
            case WARNING: {
                System.err.println("WARNING: " + validationResult.getMessage());
            }
        }
        return true;
    }

    private boolean validateOptionValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> optionEntry : options.entrySet()) {
            ConfigurationOption option = optionEntry.getValue();
            ValidationResult result = option.validate(optionValues.get(option.getName()));
            switch (result.getLevel()) {
                case ERROR: {
                    System.err.println("ERROR: " + result.getMessage());
                    return false;
                }
                case PROMPT_TO_CONTINUE: {
                    if (Bootstrap.prompt(result.getMessage(), result.getPromptDefault(), this.batchMode.get())) break;
                    return false;
                }
                case WARNING: {
                    System.err.println("WARNING: " + result.getMessage());
                    break;
                }
            }
        }
        return true;
    }

    private void setDefaultOutputPath(Map<String, Object> optionValues) {
        Iterable paths;
        Object obj = optionValues.getOrDefault("output", null);
        if ((obj == null || obj instanceof File && StringUtils.isBlank((CharSequence)((File)obj).getPath())) && (paths = (Iterable)optionValues.get("input")) != null && paths.iterator().hasNext()) {
            try {
                File canonicalInputFile = ((Path)paths.iterator().next()).toFile().getCanonicalFile();
                File outputFile = new File(canonicalInputFile.getParentFile(), canonicalInputFile.getName() + ".report");
                optionValues.put("output", outputFile);
            }
            catch (IOException e) {
                throw new WindupException("Failed to get canonical path for input file: " + ((Path)paths.iterator().next()).toFile());
            }
        }
    }

    private Object convertType(Class<?> type, String input) {
        if (input == null) {
            return null;
        }
        if (Path.class.isAssignableFrom(type)) {
            return Paths.get(input, new String[0]);
        }
        if (File.class.isAssignableFrom(type)) {
            return new File(input);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(input);
        }
        if (String.class.isAssignableFrom(type)) {
            return input;
        }
        throw new RuntimeException("Internal Error! Unrecognized type " + type.getCanonicalName());
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    private WindupProcessor getWindupProcessor() {
        return (WindupProcessor)this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupProcessor.class).get();
    }

    private String getOptionName(String argument) {
        if (argument == null) {
            return null;
        }
        if (argument.startsWith("--")) {
            return argument.substring(2);
        }
        if (argument.startsWith("-")) {
            return argument.substring(1);
        }
        return null;
    }

    private static List<Path> expandMultiAppInputDirs(List<Path> input) {
        LinkedList<Path> expanded = new LinkedList<Path>();
        for (Path path : input) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                expanded.add(path);
                continue;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                String pathString = path == null ? "" : path.toString();
                log.warning("Neither a file or directory found in input: " + pathString);
                continue;
            }
            try {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
                try {
                    for (Path subpath : directoryStream) {
                        if (!RunWindupCommand.isJavaArchive(subpath)) continue;
                        expanded.add(subpath);
                    }
                }
                finally {
                    if (directoryStream == null) continue;
                    directoryStream.close();
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read directory contents of: " + path);
            }
        }
        return expanded;
    }

    private void setDefaultOptionsValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> option : options.entrySet()) {
            if (null != optionValues.get(option.getValue().getName())) continue;
            optionValues.put(option.getValue().getName(), option.getValue().getDefaultValue());
        }
    }

    private void normalizePackagePrefixes(WindupConfiguration windupConfiguration) {
        List<String> includePackages = (List<String>)windupConfiguration.getOptionValue("packages");
        includePackages = RunWindupCommand.normalizePackagePrefixes(includePackages);
        windupConfiguration.setOptionValue("packages", includePackages);
        List<String> excludePackages = (List<String>)windupConfiguration.getOptionValue("excludePackages");
        excludePackages = RunWindupCommand.normalizePackagePrefixes(excludePackages);
        windupConfiguration.setOptionValue("excludePackages", excludePackages);
    }

    private static List<String> normalizePackagePrefixes(List<String> packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(packages.size());
        for (String pkg : packages) {
            if (pkg.endsWith(".*")) {
                System.out.println("Warning: removing the .* suffix from the package prefix: " + pkg);
            }
            result.add(StringUtils.removeEndIgnoreCase((String)pkg, (String)".*"));
        }
        return packages;
    }

    private static boolean isJavaArchive(Path path) {
        return ZipUtil.endsWithZipExtension((String)path.toString());
    }
}

