/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.bootstrap.commands.AbstractListCommandWithoutFurnace;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.util.PathUtil;

public abstract class AbstractListCommand
extends AbstractListCommandWithoutFurnace
implements Command,
FurnaceDependent {
    private Furnace furnace;

    protected Furnace getFurnace() {
        return this.furnace;
    }

    @Override
    public void setFurnace(Furnace furnace) {
        this.furnace = furnace;
    }

    protected List<Path> getUserProvidedPaths(List<String> arguments) {
        ArrayList<Path> userProvidedPaths = new ArrayList<Path>();
        boolean foundUserRulesDirectoryOption = false;
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            if (argument.equalsIgnoreCase("--userRulesDirectory")) {
                foundUserRulesDirectoryOption = true;
                continue;
            }
            if (!foundUserRulesDirectoryOption) continue;
            if (argument.startsWith("-")) break;
            userProvidedPaths.add(Paths.get(argument, new String[0]));
        }
        Path userRulesDir = PathUtil.getUserRulesDir();
        try {
            if (Files.list(userRulesDir).count() > 0L) {
                userProvidedPaths.add(userRulesDir);
            }
        }
        catch (IOException ioe) {
            System.err.println("Warning: Unable to load rules from " + userRulesDir.toString() + " due to " + ioe.getMessage());
        }
        return userProvidedPaths;
    }
}

