/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.nio.file.Path;
import java.time.Duration;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestReportUtil;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class TestChromeDriverReportUtil
extends TestReportUtil {
    public TestChromeDriverReportUtil() {
        System.setProperty("webdriver.http.factory", "netty");
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--headless=new"});
        chromeOptions.addArguments(new String[]{"--remote-allow-origins=*"});
        this.driver = new ChromeDriver(chromeOptions);
    }

    @Override
    public void loadPage(Path filePath) {
        try {
            if (!filePath.toFile().exists()) {
                throw new CheckFailedException("Requested page file does not exist: " + filePath);
            }
            this.driver.manage().timeouts().scriptTimeout(Duration.ofSeconds(30L));
            this.driver.get(filePath.toUri().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

