/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.testutil.html.TestChromeDriverReportUtil;
import org.jboss.windup.util.exception.WindupException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public class TestApplicationListUtil
extends TestChromeDriverReportUtil {
    public int getTotalStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "total");
    }

    public int getSharedStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "shared");
    }

    public int getUniqueStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "unique");
    }

    public void sortApplicationListByEffortPoints() {
        String xpathSortDiv = "//div[@id = 'sort']";
        WebElement sortDiv = this.getDriver().findElement(By.xpath((String)xpathSortDiv));
        sortDiv.findElement(By.xpath((String)"./div/button")).click();
        WebElement storyPointsSort = sortDiv.findElement(By.xpath((String)"./div/ul/li/a[contains(text(), 'Story Points')]"));
        storyPointsSort.click();
    }

    public void reverseSortOrder() {
        String xpathSortDiv = "//button[@id = 'sort-order']";
        this.getDriver().findElement(By.xpath((String)xpathSortDiv)).click();
    }

    public List<String> getApplicationNames() {
        ArrayList<String> result = new ArrayList<String>();
        List appInfoElements = this.getDriver().findElements(By.cssSelector((String)".appInfo"));
        for (WebElement appInfoRow : appInfoElements) {
            WebElement filename = appInfoRow.findElement(By.cssSelector((String)".fileName"));
            if (filename == null || filename.getText() == null) continue;
            result.add(filename.getText().trim());
        }
        return Collections.unmodifiableList(result);
    }

    public WebElement getApplicationTargetRuntimeLegendHeader() {
        return this.getDriver().findElement(By.id((String)"runtimeLegendHeader"));
    }

    public WebElement getApplicationTargetRuntimeLegendContent() {
        return this.getDriver().findElement(By.id((String)"runtimeLegendContent"));
    }

    public List<WebElement> getApplicationTargetRuntimeLabels(String applicationName) {
        ArrayList result = new ArrayList();
        List appInfoElements = this.getDriver().findElements(By.cssSelector((String)".appInfo"));
        for (WebElement appInfoRow : appInfoElements) {
            WebElement tagLink;
            WebElement filename = appInfoRow.findElement(By.cssSelector((String)".fileName"));
            if (filename == null || !(tagLink = filename.findElement(By.tagName((String)"a"))).getText().trim().equals(applicationName)) continue;
            WebElement tagDiv = filename.findElement(By.tagName((String)"div"));
            result.addAll(tagDiv.findElements(By.tagName((String)"a")));
        }
        return Collections.unmodifiableList(result);
    }

    public List<WebElement> getApplicationTechLabels(String applicationName) {
        ArrayList result = new ArrayList();
        List appInfoElements = this.getDriver().findElements(By.cssSelector((String)".appInfo"));
        for (WebElement appInfoRow : appInfoElements) {
            WebElement tagLink;
            WebElement filename = appInfoRow.findElement(By.cssSelector((String)".fileName"));
            if (filename == null || !(tagLink = filename.findElement(By.tagName((String)"a"))).getText().trim().equals(applicationName)) continue;
            List techLabels = appInfoRow.findElements(By.cssSelector((String)".techs .label"));
            result.addAll(techLabels);
        }
        return Collections.unmodifiableList(result);
    }

    public void clickTag(String applicationName, String tagName) {
        WebElement applicationRow = this.getApplicationRow(applicationName);
        if (applicationRow == null) {
            throw new WindupException("Could not find application: " + applicationName);
        }
        String xpath = "./div[contains(@class, 'traits')]/div[contains(@class, 'techs')]//span[contains(text(), '" + tagName + "')]/..";
        WebElement tagElement = applicationRow.findElement(By.xpath((String)xpath));
        JavascriptExecutor executor = (JavascriptExecutor)this.driver;
        executor.executeScript("arguments[0].click()", new Object[]{tagElement});
    }

    public boolean isDisplayed(String applicationName) {
        WebElement applicationRow = this.getApplicationRow(applicationName);
        if (applicationRow == null) {
            return false;
        }
        return applicationRow.isDisplayed();
    }

    private int getEffortPoints(String applicationName, String type) {
        WebElement applicationRow = this.getApplicationRow(applicationName);
        if (applicationRow == null) {
            return -1;
        }
        String xpath = "./div[contains(@class, 'stats')]/div[contains(@class, 'effortPoints') and contains(@class, '" + type + "')]";
        WebElement pointsSectionElement = applicationRow.findElement(By.xpath((String)xpath));
        WebElement effortPointsElement = pointsSectionElement.findElement(By.cssSelector((String)".points"));
        return Integer.parseInt(effortPointsElement.getText());
    }

    private WebElement getApplicationRow(String applicationName) {
        List appInfoElements = this.getDriver().findElements(By.cssSelector((String)".appInfo"));
        for (WebElement appInfoRow : appInfoElements) {
            WebElement filename = appInfoRow.findElement(By.cssSelector((String)".fileName"));
            if (filename == null || !StringUtils.equals((CharSequence)filename.getText(), (CharSequence)applicationName)) continue;
            return appInfoRow;
        }
        return null;
    }
}

