/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestChromeDriverReportUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class TestDependencyReportUtil
extends TestChromeDriverReportUtil {
    public boolean findDependencyElement(String fileName, String gav, String dependencyHash, String version, String org, List<String> paths) {
        return this.findDependencyElement(fileName, null, gav, dependencyHash, version, org, paths);
    }

    public boolean findDependencyElement(String fileName, String name, String gav, String dependencyHash, String version, String org, List<String> paths) {
        List elements = this.getDriver().findElements(By.xpath((String)("//*[@id='" + fileName + "']")));
        if (elements == null || elements.isEmpty()) {
            throw new CheckFailedException("Unable to find dependencies");
        }
        if (elements.size() == 1) {
            WebElement dependency = (WebElement)elements.get(0);
            WebElement h3 = dependency.findElement(By.tagName((String)"h3"));
            if (h3 != null && h3.getText().equals(fileName)) {
                WebElement dependencyParent = dependency.findElement(By.xpath((String)".."));
                return this.checkDependency(dependencyParent, name, fileName, gav, dependencyHash, version, org, paths);
            }
        } else {
            throw new CheckFailedException("Found more than one dependency of the same filename - " + fileName);
        }
        return false;
    }

    public int getNumberOfJarsOnPage() {
        List elements = this.getDriver().findElements(By.className((String)"dependency"));
        return elements != null ? elements.size() : 0;
    }

    public int getNumberOfArchivePathsOnPage(String archiveName) {
        String id = archiveName + "-paths";
        List pathElements = this.getDriver().findElements(By.xpath((String)("//ul[@id='" + id + "']/li")));
        return pathElements != null ? pathElements.size() : 0;
    }

    boolean checkDependency(WebElement dependencyElement, String name, String fileName, String gav, String dependencyHash, String version, String org, List<String> paths) {
        boolean found = false;
        if (gav != null && !gav.isEmpty() && (found = this.isDependencyPropertyExists(dependencyElement, "maven", gav, fileName))) {
            found = this.isDependencyPropertyURLExists(dependencyElement, "maven", gav, fileName);
        }
        if (dependencyHash != null && !dependencyHash.isEmpty() && found) {
            found = this.isDependencyPropertyExists(dependencyElement, "hash", dependencyHash, fileName);
        }
        if (name != null && !name.isEmpty() && found) {
            found = this.isDependencyPropertyExists(dependencyElement, "name", name, fileName);
        }
        if (version != null && !version.isEmpty() && found) {
            found = this.isDependencyPropertyExists(dependencyElement, "version", version, fileName);
        }
        if (org != null && !org.isEmpty() && found) {
            found = this.isDependencyPropertyExists(dependencyElement, "org", org, fileName);
        }
        if (paths != null && !paths.isEmpty() && found) {
            found = this.isDependencyPathsExists(dependencyElement, "paths", paths, fileName);
        }
        return found;
    }

    private boolean isDependencyPathsExists(WebElement traitsElement, String key, List<String> foundPaths, String dependencyName) {
        String id = dependencyName + "-" + key;
        try {
            List pathElements = traitsElement.findElements(By.xpath((String)("//ul[@id='" + id + "']/li")));
            if (pathElements.size() != foundPaths.size()) {
                return false;
            }
            ArrayList<String> pathsOnPage = new ArrayList<String>();
            for (WebElement webElement : pathElements) {
                pathsOnPage.add(webElement.getText());
            }
            pathsOnPage.removeAll(foundPaths);
            if (pathsOnPage.isEmpty()) {
                return true;
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("Element not found " + e.getLocalizedMessage());
        }
        return false;
    }

    private boolean isDependencyPropertyURLExists(WebElement traitsElement, String key, String value, String dependencyName) {
        String id = dependencyName + "-" + key;
        try {
            WebElement url;
            WebElement header = traitsElement.findElement(By.id((String)id));
            if (header != null && (url = traitsElement.findElement(By.partialLinkText((String)value))) != null) {
                return true;
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("Element not found " + e.getLocalizedMessage());
        }
        return false;
    }

    private boolean isDependencyPropertyExists(WebElement traitsElement, String key, String value, String dependencyName) {
        String id = dependencyName + "-" + key;
        try {
            WebElement header = traitsElement.findElement(By.id((String)id));
            if (header != null && header.getText().endsWith(value)) {
                return true;
            }
        }
        catch (NoSuchElementException e) {
            System.err.println("Element not found " + e.getLocalizedMessage());
        }
        return false;
    }
}

