/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class TestReportUtil {
    private static final Logger LOG = Logger.getLogger(TestReportUtil.class.getName());
    protected WebDriver driver = new WindupHtmlUnitDriver(BrowserVersion.FIREFOX, true);

    public void loadPage(Path filePath) {
        LOG.info("Loading page: " + filePath);
        if (!filePath.toFile().exists()) {
            throw new CheckFailedException("Requested page file does not exist: " + filePath);
        }
        this.getDriver().get(filePath.toUri().toString());
    }

    protected WebDriver getDriver() {
        return this.driver;
    }

    boolean checkValueInTable(WebElement element, String ... columnValues) {
        List rowElements = element.findElements(By.xpath((String)".//tr"));
        boolean foundExpectedResult = false;
        for (WebElement rowElement : rowElements) {
            boolean rowMatches = true;
            for (int i = 0; i < columnValues.length; ++i) {
                String expectedValue = columnValues[i];
                List tdElements = rowElement.findElements(By.xpath((String)("./td[position() = " + (i + 1) + "]")));
                if (tdElements.size() != 1) {
                    rowMatches = false;
                    break;
                }
                String actualValue = ((WebElement)tdElements.get(0)).getText().trim();
                if (actualValue.trim().equals(expectedValue.trim())) continue;
                rowMatches = false;
                break;
            }
            if (!rowMatches) continue;
            foundExpectedResult = true;
            break;
        }
        return foundExpectedResult;
    }

    public class WindupHtmlUnitDriver
    extends HtmlUnitDriver {
        public WindupHtmlUnitDriver(BrowserVersion version, boolean enableJavascript) {
            super(version, enableJavascript);
        }

        protected WebClient modifyWebClient(WebClient client) {
            WebClient modifiedClient = super.modifyWebClient(client);
            modifiedClient.getOptions().setThrowExceptionOnScriptError(false);
            modifiedClient.setCssErrorHandler((CSSErrorHandler)new SilentCssErrorHandler());
            return modifiedClient;
        }
    }
}

