/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.rules;

import java.util.Objects;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RetryRule
implements TestRule {
    private final int retryCount;

    public RetryRule(int retryCount) {
        this.retryCount = retryCount;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable caughtThrowable = null;
                for (int i = 0; i < RetryRule.this.retryCount; ++i) {
                    try {
                        base.evaluate();
                        return;
                    }
                    catch (Throwable t) {
                        caughtThrowable = t;
                        System.err.println(description.getDisplayName() + ": run " + (i + 1) + " failed.");
                        continue;
                    }
                }
                System.err.println(description.getDisplayName() + ": Giving up after " + RetryRule.this.retryCount + " failures.");
                throw Objects.requireNonNull(caughtThrowable);
            }
        };
    }
}

