/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestChromeDriverReportUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class TestJavaApplicationOverviewUtil
extends TestChromeDriverReportUtil {
    @Override
    public void loadPage(Path filePath) {
        try {
            Path modifiedPath = filePath.getParent().resolve(filePath.getFileName().toString() + "_modified.html");
            String contents = FileUtils.readFileToString((File)filePath.toFile(), (Charset)Charset.defaultCharset());
            contents = contents.replace("$.plot", "");
            contents = contents.replace("<script src=\"resources/libraries/flot/jquery.flot.min.js\"></script>", "<script>$.plot = function(){}</script>");
            contents = contents.replace("<script src=\"resources/libraries/flot/jquery.flot.pie.min.js\"></script>", "");
            contents = contents.replace("<script src=\"resources/js/jquery.color-2.1.2.min.js\"></script>", "<script>jQuery.Color = function(){ return { toHexString: function(){ return \"#aa0000\"; } } }</script>");
            try (FileWriter writer = new FileWriter(modifiedPath.toFile());){
                writer.append(contents);
            }
            this.getDriver().get(modifiedPath.toUri().toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkApplicationMessage(String message) {
        List applicationMessageElements = this.getDriver().findElements(By.className((String)"application-message"));
        for (WebElement applicationMessageElement : applicationMessageElements) {
            if (!message.equals(applicationMessageElement.getText())) continue;
            return;
        }
        throw new CheckFailedException("Could not find an application message with text: " + message);
    }

    public void checkMainEffort(int expectedEffort) {
        int effort;
        WebElement effortElement = this.getDriver().findElement(By.xpath((String)".//div[contains(@class, 'container') and contains(@class, 'mainGraphContainer')]//div[@class = 'points']/div[@class = 'number']"));
        String effortString = effortElement.getText().trim();
        effortString = effortString.replace(",", "");
        try {
            effort = Integer.parseInt(effortString);
        }
        catch (Exception e) {
            throw new CheckFailedException("Effort: " + effortString + " could not be parsed as numeric!");
        }
        if (effort != expectedEffort) {
            throw new CheckFailedException("Effort was " + effort + " but was expected to be " + expectedEffort);
        }
    }

    public void checkAppSectionEffort(String appSection, int expectedEffort) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        String xpath = this.getElementXPath(this.getDriver(), appSectionEl) + "/../..//div[@class = \\'points\\']/div[text() = \\'Story Points\\']/../div[@class = \\'number\\']";
        String effortString = this.getStringValueForXpathElement(this.getDriver(), xpath).trim();
        effortString = effortString.replace(",", "");
        try {
            int effort = Integer.parseInt(effortString);
            if (effort != expectedEffort) {
                throw new CheckFailedException("Effort was " + effort + " but was expected to be " + expectedEffort);
            }
        }
        catch (Exception e) {
            throw new CheckFailedException("Effort: " + effortString + " could not be parsed as numeric!");
        }
    }

    public void checkFilePathEffort(String appSection, String filePath, int effort) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 4]"));
        for (WebElement element : elements) {
            if (element.getText() == null) continue;
            try {
                int number = Integer.parseInt(this.getTextForElement(element));
                if (number == effort) {
                    return;
                }
                throw new CheckFailedException("Found row with appSection: " + appSection + " and filePath: " + filePath + ", but effort was: " + number + " (expected value: " + effort + ")");
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with effort: " + effort);
    }

    public void checkFilePathAndIssues(String appSection, String filePath, String text) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 3]"));
        for (WebElement element : elements) {
            String elementText = this.getTextForElement(element);
            if (elementText == null || !elementText.contains(text)) continue;
            return;
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with issue: " + text);
    }

    public void checkFilePathAndTag(String appSection, String filePath, String tag) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
        List elements = fileRowElement.findElements(By.xpath((String)"./td[position() = 2]/span"));
        for (WebElement element : elements) {
            String spanValue = this.getTextForElement(element);
            if (!spanValue.equals(tag)) continue;
            return;
        }
        throw new CheckFailedException("Unable to find app: " + appSection + " file: " + filePath + " with tag: " + tag);
    }

    private String getTextForElement(WebElement element) {
        String xpath = this.getElementXPath(this.driver, element);
        String result = this.getStringValueForXpathElement(this.driver, xpath);
        return result.trim();
    }

    private String getElementXPath(WebDriver driver, WebElement element) {
        Object xpath = (String)((JavascriptExecutor)driver).executeScript("gPt=function(c){if(c.id!==''){return'id(\"'+c.id+'\")'}if(c===document.body){return c.tagName}var a=0;var e=c.parentNode.childNodes;for(var b=0;b<e.length;b++){var d=e[b];if(d===c){return gPt(c.parentNode)+'/'+c.tagName+'['+(a+1)+']'}if(d.nodeType===1&&d.tagName===c.tagName){a++}}};return gPt(arguments[0]).toLowerCase();", new Object[]{element});
        if (!StringUtils.startsWith((CharSequence)xpath, (CharSequence)"id(\"")) {
            xpath = "/html/" + (String)xpath;
        }
        return xpath;
    }

    private String getStringValueForXpathElement(WebDriver driver, String xpathToElement) {
        return (String)((JavascriptExecutor)driver).executeScript("var foundDocument=document.evaluate( '" + xpathToElement + "', document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null ).singleNodeValue; if(foundDocument !=null) {return foundDocument.textContent;} else {return null} ", new Object[0]);
    }

    public void checkFilePath(String appSection, String filePath) {
        WebElement appSectionEl = this.getAppSectionElement(appSection);
        if (appSectionEl == null) {
            throw new CheckFailedException("Unable to find app section with name: " + appSection);
        }
        WebElement fileRowElement = this.getFileRowElement(appSection, filePath);
        if (fileRowElement == null) {
            throw new CheckFailedException("Unable to find row for filePath: " + filePath);
        }
    }

    private WebElement getFileRowElement(String appSection, String filePath) {
        WebElement fileTable = this.getAppSectionElement(appSection).findElement(By.xpath((String)"../../div[contains(@class,'panel-body')]/table"));
        WebElement fileRow = fileTable.findElement(By.xpath((String)("./tbody/tr/td/a[normalize-space(text()) = '" + filePath + "']/../..")));
        return fileRow;
    }

    private WebElement getAppSectionElement(String appSection) {
        List titleElements = this.getDriver().findElements(By.className((String)"panel-title"));
        for (WebElement el : titleElements) {
            String panelTitleText = el.getText();
            if (panelTitleText == null || !appSection.equals((panelTitleText = this.parseOutAppTitle(panelTitleText)).trim())) continue;
            return el;
        }
        return null;
    }

    private String parseOutAppTitle(String input) {
        return input.replaceAll("\\(.*\\)", "");
    }
}

