/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestReportUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class TestDependencyGraphReportUtil
extends TestReportUtil {
    public TestDependencyGraphReportUtil() {
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--headless"});
        this.driver = new ChromeDriver(chromeOptions);
    }

    @Override
    public void loadPage(Path filePath) {
        try {
            if (!filePath.toFile().exists()) {
                throw new CheckFailedException("Requested page file does not exist: " + filePath);
            }
            this.driver.manage().timeouts().setScriptTimeout(30L, TimeUnit.SECONDS);
            this.driver.get(filePath.toUri().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumberOfArchivesInTheGraph() {
        List dependencies = this.getDriver().findElements(By.tagName((String)"g"));
        return dependencies != null ? dependencies.size() : 0;
    }

    public long getNumberOfArchivesInTheGraphByName(String withName) {
        return this.getDriver().findElements(By.tagName((String)"title")).stream().filter(webElement -> withName.equals(webElement.getText())).count();
    }

    public int getNumberOfRelationsInTheGraph() {
        List relations = this.getDriver().findElements(By.tagName((String)"line"));
        return relations != null ? relations.size() : 0;
    }
}

