/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.testutil.html.CheckFailedException;
import org.jboss.windup.testutil.html.TestReportUtil;
import org.jboss.windup.util.Util;
import org.ocpsoft.common.util.Strings;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class TestTechReportUtil
extends TestReportUtil {
    private static final Logger LOG = Logger.getLogger(TestReportUtil.class.getName());
    final int COLS_BEFORE_BUBBLES = 1;

    public void checkTechGlobalReport(Path path, List<BubbleInfo> bubblesExpected) {
        this.loadPage(path);
        for (BubbleInfo bubbleInfo : bubblesExpected) {
            this.checkBubble(bubbleInfo);
        }
        this.getDriver().close();
    }

    public void checkPoints(String appName, PointsType pointsType, int expectedCount) {
        String columnName;
        LOG.info("    Checking points " + appName + ", pointstype: " + (Object)((Object)pointsType));
        switch (pointsType) {
            case MANDATORY: {
                columnName = "Mandatory (SP)";
                break;
            }
            case POTENTIAL: {
                columnName = "Potential (Count)";
                break;
            }
            case CLOUD_MANDATORY: {
                columnName = "Cloud Mandatory (SP)";
                break;
            }
            default: {
                throw new CheckFailedException("Unrecognized type: " + (Object)((Object)pointsType));
            }
        }
        int colOffset = this.getPunchCardReportColumnOffset(columnName);
        String xpath = String.format("//tr[@class='app' and td/a[normalize-space()='%s']]/td[position()=%d]", appName, colOffset + 1 + 1);
        List bubbleCells = this.getDriver().findElements(By.xpath((String)xpath));
        if (bubbleCells.isEmpty()) {
            throw new CheckFailedException(String.format("Cell not found for app %s and column %s;  xpath: " + xpath, new Object[]{appName, pointsType}));
        }
        WebElement cell = (WebElement)bubbleCells.get(0);
        String cellText = cell.getText();
        if (StringUtils.isBlank((CharSequence)cellText)) {
            throw new CheckFailedException("No contents found for " + appName + " points type: " + (Object)((Object)pointsType));
        }
        int count = Integer.parseInt(cellText = cellText.trim());
        if (expectedCount != count) {
            throw new CheckFailedException("For " + appName + " points type: " + (Object)((Object)pointsType) + ", expected: " + expectedCount + ", but actual value was: " + count);
        }
    }

    private void checkBubble(BubbleInfo bubbleExpected) {
        LOG.info("    Checking bubble " + bubbleExpected);
        String appName = bubbleExpected.appName.trim();
        int colOffset = this.getPunchCardReportColumnOffset(bubbleExpected.techColumnLabel);
        String xpath = String.format("//tr[@class='app' and td/a[normalize-space()='%s']]/td[position()=%d]", appName, colOffset + 1 + 1);
        List bubbleCells = this.getDriver().findElements(By.xpath((String)xpath));
        if (bubbleCells.isEmpty()) {
            throw new CheckFailedException(String.format("Bubble cell not found for app %s and column %s;  xpath: " + xpath, appName, bubbleExpected.techColumnLabel));
        }
        WebElement bubbleCell = (WebElement)bubbleCells.get(0);
        int actualSize = this.parseSizeFromClasses(bubbleCell.getAttribute("class"));
        if (actualSize < bubbleExpected.minSize) {
            throw new CheckFailedException(String.format("Bubble size smaller than expected: %d < %d", actualSize, bubbleExpected.minSize));
        }
        if (actualSize > bubbleExpected.maxSize) {
            throw new CheckFailedException(String.format("Bubble size larger than expected: %d > %d", actualSize, bubbleExpected.maxSize));
        }
    }

    private int parseSizeFromClasses(String classes) {
        Matcher mat = Pattern.compile("(?:.*size)(\\d)(?:.*)").matcher(classes);
        mat.matches();
        String size = mat.group(1);
        return Integer.valueOf(size);
    }

    private int getPunchCardReportColumnOffset(String label) {
        label = label.trim();
        List headersTR = this.getDriver().findElements(By.xpath((String)String.format("//tr[@class='headersGroup']", label)));
        this.assertNotEmpty(headersTR, "headers row");
        List headerDIV = this.getDriver().findElements(By.xpath((String)String.format("//tr[@class='headersGroup']/td/div[normalize-space()='%s']", label)));
        this.assertNotEmpty(headerDIV, "header column div " + label);
        String xpath = String.format("//tr[@class='headersGroup']/td[div[normalize-space()='%s']]/preceding-sibling::td", label);
        List precedingSiblings = this.getDriver().findElements(By.xpath((String)xpath));
        this.assertNotEmpty(precedingSiblings, "precending siblings of header column div " + label);
        return precedingSiblings.size() - 1;
    }

    public void checkTechBoxReport(Path path, List<BoxInfo> boxesExpected) {
        this.loadPage(path);
        ArrayList<String> errors = new ArrayList<String>();
        for (BoxInfo box : boxesExpected) {
            String error;
            if (box.sectorLabel == null) {
                this.checkNoBoxInRow(box);
                continue;
            }
            if (box.boxLabel == null || null == (error = this.checkBox(box))) continue;
            errors.add(error);
        }
        String glue = Util.NL + "  * ";
        if (!errors.isEmpty()) {
            throw new CheckFailedException("Tech report is wrong: " + glue + Strings.join(errors, (String)glue));
        }
        this.getDriver().close();
    }

    private void checkNoBoxInRow(BoxInfo boxNotExpected) {
        String xpath = String.format("//tr[@class='rowHeader' and //div[normalize-space()='%s']]//div[contains(@class,'box')]", boxNotExpected.rowLabel);
        List boxes = this.getDriver().findElements(By.xpath((String)xpath));
        if (!boxes.isEmpty()) {
            throw new CheckFailedException(String.format("There should be no boxes for row '%s';  xpath: " + xpath, boxNotExpected.rowLabel));
        }
    }

    private void checkNoBoxUnderSector(BoxInfo boxNotExpected) {
        int sectorOffset = this.getBoxesReportSectorOffset(boxNotExpected.sectorLabel);
        String xpath = String.format("//tr[@class='rowHeader' and //div[normalize-space()='%s']]//td[position()=%d]//div[contains(@class,'box')", boxNotExpected.rowLabel, sectorOffset);
        List boxes = this.getDriver().findElements(By.xpath((String)xpath));
        if (!boxes.isEmpty()) {
            throw new CheckFailedException(String.format("There should be no boxes for row '%s' and sector '%s';  xpath: " + xpath, boxNotExpected.rowLabel, boxNotExpected.sectorLabel));
        }
    }

    private int getBoxesReportSectorOffset(String sectorLabel) {
        return 0;
    }

    private String checkBox(BoxInfo boxExpected) {
        String xpath = String.format("//div[contains(@class,'box') and //h4[normalize-space() = '%s']]", boxExpected.boxLabel);
        List boxes = this.getDriver().findElements(By.xpath((String)xpath));
        if (boxes.isEmpty()) {
            return String.format("Box '%s' not found for row '%s' and sector '%s';  xpath: " + xpath, boxExpected.boxLabel, boxExpected.rowLabel, boxExpected.sectorLabel);
        }
        List techItems = ((WebElement)boxes.get(0)).findElements(By.xpath((String)String.format("//ul/li[node()[normalize-space() = '%s']]", boxExpected.techName)));
        if (techItems.isEmpty()) {
            return String.format("Tech '%s' not found in box '%s' at row '%s' and under sector '%s'", boxExpected.techName, boxExpected.boxLabel, boxExpected.rowLabel, boxExpected.sectorLabel);
        }
        if (boxExpected.minCount == 0) {
            return null;
        }
        WebElement techLi = (WebElement)techItems.get(0);
        List countBs = techLi.findElements(By.tagName((String)"b"));
        if (countBs.isEmpty()) {
            return String.format("Count was missing, expected to be %d for tech '%s' not found in box '%s' at row '%s' and under sector '%s'", boxExpected.minCount, boxExpected.techName, boxExpected.boxLabel, boxExpected.rowLabel, boxExpected.sectorLabel);
        }
        Integer actualCount = Integer.valueOf(((WebElement)countBs.get(0)).getText());
        if (actualCount < boxExpected.minCount) {
            return String.format("Count was %d, expected to be at least %d for tech '%s' not found in box '%s' at row '%s' and under sector '%s'", actualCount, boxExpected.minCount, boxExpected.techName, boxExpected.boxLabel, boxExpected.rowLabel, boxExpected.sectorLabel);
        }
        return null;
    }

    private boolean assertNotNull(Object object, String whatIsIt, boolean throwIfNotFound) {
        if (object == null && throwIfNotFound) {
            throw new CheckFailedException(whatIsIt + " was not found on the page.");
        }
        return object != null;
    }

    private void assertNotEmpty(Iterable iterable, String whatIsIt) {
        if (!iterable.iterator().hasNext()) {
            throw new CheckFailedException(whatIsIt + " was not found on the page.");
        }
    }

    public static class BoxInfo {
        String rowLabel;
        String sectorLabel;
        String boxLabel;
        String techName;
        int minCount;
        int maxCount;

        public BoxInfo(String rowLabel, String sectorLabel, String boxLabel, String techName, int minCount, int maxCount) {
            this.rowLabel = rowLabel;
            this.sectorLabel = sectorLabel;
            this.boxLabel = boxLabel;
            this.techName = techName;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }
    }

    public static class BubbleInfo {
        String appName;
        String techColumnLabel;
        int minSize;
        int maxSize;

        public BubbleInfo(String appName, String techColumnLabel, int minSize, int maxSize) {
            this.appName = appName;
            this.techColumnLabel = techColumnLabel;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        public String toString() {
            return "BubbleInfo{appName='" + this.appName + '\'' + ", techColumnLabel='" + this.techColumnLabel + '\'' + ", " + this.minSize + " to " + this.maxSize + '}';
        }
    }

    public static enum PointsType {
        MANDATORY,
        CLOUD_MANDATORY,
        POTENTIAL;

    }
}

