/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.testutil.html;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.testutil.html.TestReportUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class TestApplicationListUtil
extends TestReportUtil {
    public int getTotalStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "total");
    }

    public int getSharedStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "shared");
    }

    public int getUniqueStoryPoints(String applicationName) {
        return this.getEffortPoints(applicationName, "unique");
    }

    private int getEffortPoints(String applicationName, String type) {
        WebElement applicationRow = this.getApplicationRow(applicationName);
        if (applicationRow == null) {
            return -1;
        }
        String xpath = "./div[contains(@class, 'stats')]/div[contains(@class, 'effortPoints') and contains(@class, '" + type + "')]";
        WebElement pointsSectionElement = applicationRow.findElement(By.xpath((String)xpath));
        WebElement effortPointsElement = pointsSectionElement.findElement(By.cssSelector((String)".points"));
        return Integer.parseInt(effortPointsElement.getText());
    }

    private WebElement getApplicationRow(String applicationName) {
        List appInfoElements = this.getDriver().findElements(By.cssSelector((String)".appInfo"));
        for (WebElement appInfoRow : appInfoElements) {
            WebElement filename = appInfoRow.findElement(By.cssSelector((String)".fileName"));
            if (filename == null || !StringUtils.equals((CharSequence)filename.getText(), (CharSequence)applicationName)) continue;
            return appInfoRow;
        }
        return null;
    }
}

