/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTVisitor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TextElement;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldHolderSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.PropertyHolderSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.forge.roaster.model.util.Assert;
import org.jboss.forge.roaster.model.util.Strings;

class PropertyImpl<O extends JavaSource<O> & PropertyHolderSource<O>>
implements PropertySource<O> {
    private final O origin;
    private String name;

    PropertyImpl(String name, O origin) {
        this.origin = origin;
        this.name = name;
    }

    public Object getInternal() {
        return this.getOrigin().getInternal();
    }

    public O getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name == null ? "<missing>" : this.name;
    }

    public Type<O> getType() {
        if (this.isAccessible()) {
            return this.getAccessor().getReturnType();
        }
        if (this.isMutable()) {
            return ((ParameterSource)this.getMutator().getParameters().get(0)).getType();
        }
        if (this.hasField()) {
            return this.getField().getType();
        }
        return null;
    }

    public boolean hasField() {
        return this.getField() != null;
    }

    public FieldSource<O> getField() {
        FieldSource field = ((FieldHolderSource)this.getOrigin()).getField(this.name);
        if (field != null && !field.isStatic()) {
            return field;
        }
        return null;
    }

    public boolean isAccessible() {
        return this.getAccessor() != null;
    }

    public boolean isMutable() {
        return this.getMutator() != null;
    }

    public MethodSource<O> getAccessor() {
        for (MethodSource method : ((MethodHolderSource)this.getOrigin()).getMethods()) {
            if (!this.isAccessor((Method<O, ?>)method)) continue;
            return method;
        }
        return null;
    }

    public MethodSource<O> getMutator() {
        Object type = this.hasField() ? this.getField().getType() : (this.isAccessible() ? this.getAccessor().getReturnType() : null);
        for (MethodSource method : ((MethodHolderSource)this.getOrigin()).getMethods()) {
            if (!this.isMutator((Method<O, ?>)method) || type != null && !Strings.areEqual((String)type.getQualifiedName(), (String)((ParameterSource)method.getParameters().get(0)).getType().getQualifiedName())) continue;
            return method;
        }
        return null;
    }

    public MethodSource<O> createAccessor() {
        Assert.isTrue((this.getAccessor() == null ? 1 : 0) != 0, (String)"Accessor method already exists");
        Type<O> type = this.getType();
        String accessorName = PropertyImpl.methodName(type.isType(Boolean.TYPE) ? "is" : "get", this.name);
        MethodSource result = (MethodSource)((MethodHolderSource)this.getOrigin()).addMethod().setReturnType(this.typeName()).setName(accessorName);
        if (!this.getOrigin().isInterface()) {
            result.setVisibility(Visibility.PUBLIC);
            if (this.hasField()) {
                String body = String.format("return %s;", this.getName());
                result.setBody(body);
            }
        }
        return result;
    }

    public MethodSource<O> createMutator() {
        Assert.isTrue((this.getMutator() == null ? 1 : 0) != 0, (String)"Mutator method already exists");
        String mutatorName = PropertyImpl.methodName("set", this.name);
        String parameters = String.format("%s %s", this.typeName(), this.getName());
        MethodSource result = ((MethodSource)((MethodHolderSource)this.getOrigin()).addMethod().setReturnTypeVoid().setName(mutatorName)).setParameters(parameters);
        if (!this.getOrigin().isInterface()) {
            result.setVisibility(Visibility.PUBLIC);
            if (this.hasField()) {
                String body = String.format("this.%1$s = %1$s;", this.getName());
                result.setBody(body);
            }
        }
        return result;
    }

    public FieldSource<O> createField() {
        Assert.isFalse((boolean)this.getOrigin().isInterface(), (String)"An interface cannot declare a nonstatic field");
        Assert.isTrue((this.getField() == null ? 1 : 0) != 0, (String)"Field already exists");
        FieldSource result = (FieldSource)((FieldSource)((FieldHolderSource)this.getOrigin()).addField().setVisibility(Visibility.PRIVATE)).setType(this.typeName()).setName(this.name);
        if (this.getOrigin().isEnum()) {
            result.setFinal(true);
        }
        if (this.isAccessible() && !this.getAccessor().isAbstract()) {
            this.removeAccessor();
            this.createAccessor();
        }
        if (this.isMutable() && !this.getMutator().isAbstract()) {
            this.removeMutator();
            this.createMutator();
        }
        return result;
    }

    public PropertySource<O> setName(final String name) {
        Assert.isFalse((boolean)Strings.isBlank((String)name), (String)"Property name cannot be null/empty/blank");
        if (this.hasField()) {
            this.getField().setName(name);
        }
        final String oldName = this.name;
        boolean visitDocTags = true;
        ASTVisitor renameVisitor = new ASTVisitor(true){

            @Override
            public boolean visit(SimpleName node) {
                if (Strings.areEqual((String)oldName, (String)node.getIdentifier())) {
                    node.setIdentifier(name);
                }
                return super.visit(node);
            }

            @Override
            public boolean visit(TextElement node) {
                String text = node.getText();
                if (!text.contains(oldName)) {
                    return super.visit(node);
                }
                int matchLength = oldName.length();
                int textLength = text.length();
                StringBuilder buf = new StringBuilder(text.length());
                ParsePosition pos = new ParsePosition(0);
                while (pos.getIndex() < textLength) {
                    int next;
                    int index = pos.getIndex();
                    char c = text.charAt(index);
                    if (Character.isJavaIdentifierStart(c) && (next = index + matchLength) <= textLength && Strings.areEqual((String)oldName, (String)text.substring(index, next))) {
                        buf.append(name);
                        pos.setIndex(next);
                        continue;
                    }
                    buf.append(c);
                    pos.setIndex(index + 1);
                }
                node.setText(buf.toString());
                return super.visit(node);
            }
        };
        if (this.isAccessible()) {
            MethodSource<O> accessor = this.getAccessor();
            String prefix = accessor.getReturnType().isType(Boolean.TYPE) ? "is" : "get";
            accessor.setName(PropertyImpl.methodName(prefix, name));
            ((MethodDeclaration)accessor.getInternal()).accept(renameVisitor);
        }
        if (this.isMutable()) {
            MethodSource<O> mutator = this.getMutator();
            mutator.setName(PropertyImpl.methodName("set", name));
            ((MethodDeclaration)mutator.getInternal()).accept(renameVisitor);
        }
        this.name = name;
        return this;
    }

    public PropertySource<O> setType(Class<?> clazz) {
        return this.setType(clazz.getName());
    }

    public PropertySource<O> setType(String type) {
        MethodSource<O> accessor = this.getAccessor();
        MethodSource<O> mutator = this.getMutator();
        FieldSource<O> field = this.getField();
        if (accessor != null) {
            Type originalType = accessor.getReturnType();
            accessor.setReturnType(type);
            if (originalType.isType(Boolean.TYPE) || accessor.getReturnType().isType(Boolean.TYPE)) {
                String accessorName = PropertyImpl.methodName(accessor.getReturnType().isType(Boolean.TYPE) ? "is" : "get", this.getName());
                accessor.setName(accessorName);
            }
        }
        if (mutator != null) {
            for (ParameterSource param : mutator.getParameters()) {
                mutator.removeParameter(param);
            }
            mutator.addParameter(type, this.getName());
        }
        if (field != null) {
            field.setType(type);
        }
        return this;
    }

    public PropertySource<O> setType(JavaType<?> entity) {
        return this.setType(entity.getQualifiedName());
    }

    public PropertySource<O> setAccessible(boolean accessible) {
        if (this.isAccessible() != accessible) {
            if (accessible) {
                this.createAccessor();
            } else {
                this.removeAccessor();
            }
        }
        return this;
    }

    public PropertySource<O> setMutable(boolean mutable) {
        if (this.isMutable() != mutable) {
            if (mutable) {
                if (this.hasField()) {
                    this.getField().setFinal(false);
                }
                this.createMutator();
            } else {
                if (this.hasField()) {
                    this.getField().setFinal(true);
                }
                this.removeMutator();
            }
        }
        return this;
    }

    public PropertySource<O> removeAccessor() {
        if (this.isAccessible()) {
            ((MethodHolderSource)this.getOrigin()).removeMethod(this.getAccessor());
        }
        return this;
    }

    public PropertySource<O> removeMutator() {
        if (this.isMutable()) {
            ((MethodHolderSource)this.getOrigin()).removeMethod(this.getMutator());
        }
        return this;
    }

    public PropertySource<O> removeField() {
        if (this.hasField()) {
            ((FieldHolderSource)this.getOrigin()).removeField(this.getField());
        }
        return this;
    }

    public String toString() {
        return "Property: " + this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.getOrigin() == other.getOrigin() && Strings.areEqual((String)this.getName(), (String)other.getName());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.getOrigin(), this.getName()});
    }

    public boolean isValid() {
        return this.hasField() || this.isAccessible() || this.isMutable();
    }

    private String typeName() {
        Type<O> type = this.getType();
        return type == null ? "<missing>" : type.toString();
    }

    private boolean isAccessor(Method<O, ?> method) {
        if (method.isConstructor()) {
            return false;
        }
        if (method.isReturnTypeVoid()) {
            return false;
        }
        if (method.getParameters().isEmpty()) {
            if (method.getReturnType().isType(Boolean.TYPE) && Strings.areEqual((String)method.getName(), (String)PropertyImpl.methodName("is", this.name))) {
                return true;
            }
            return Strings.areEqual((String)method.getName(), (String)PropertyImpl.methodName("get", this.name));
        }
        return false;
    }

    private boolean isMutator(Method<O, ?> method) {
        if (method.isConstructor()) {
            return false;
        }
        return method.isReturnTypeVoid() && method.getParameters().size() == 1 && Strings.areEqual((String)method.getName(), (String)PropertyImpl.methodName("set", this.name));
    }

    private static String methodName(String prefix, String property) {
        return prefix + Strings.capitalize((String)property);
    }

    public Annotation<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        MethodSource<O> mutator;
        MethodSource<O> accessor;
        AnnotationSource ann = null;
        FieldSource<O> field = this.getField();
        if (field != null) {
            ann = field.getAnnotation(type);
        }
        if (ann == null && (accessor = this.getAccessor()) != null) {
            ann = accessor.getAnnotation(type);
        }
        if (ann == null && (mutator = this.getMutator()) != null) {
            ann = mutator.getAnnotation(type);
        }
        return ann;
    }

    public Annotation<O> getAnnotation(String type) {
        MethodSource<O> mutator;
        MethodSource<O> accessor;
        AnnotationSource ann = null;
        FieldSource<O> field = this.getField();
        if (field != null) {
            ann = field.getAnnotation(type);
        }
        if (ann == null && (accessor = this.getAccessor()) != null) {
            ann = accessor.getAnnotation(type);
        }
        if (ann == null && (mutator = this.getMutator()) != null) {
            ann = mutator.getAnnotation(type);
        }
        return ann;
    }

    public List<? extends Annotation<O>> getAnnotations() {
        MethodSource<O> mutator;
        MethodSource<O> accessor;
        ArrayList annotations = new ArrayList();
        FieldSource<O> field = this.getField();
        if (field != null) {
            List fieldAnnotations = field.getAnnotations();
            annotations.addAll(fieldAnnotations);
        }
        if ((accessor = this.getAccessor()) != null) {
            List accessorAnnotations = accessor.getAnnotations();
            annotations.addAll(accessorAnnotations);
        }
        if ((mutator = this.getMutator()) != null) {
            List mutatorAnnotations = mutator.getAnnotations();
            annotations.addAll(mutatorAnnotations);
        }
        return annotations;
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        MethodSource<O> mutator;
        MethodSource<O> accessor;
        boolean hasAnnotation = false;
        FieldSource<O> field = this.getField();
        if (field != null) {
            hasAnnotation = field.hasAnnotation(type);
        }
        if (!hasAnnotation && (accessor = this.getAccessor()) != null) {
            hasAnnotation = accessor.hasAnnotation(type);
        }
        if (!hasAnnotation && (mutator = this.getMutator()) != null) {
            hasAnnotation = mutator.hasAnnotation(type);
        }
        return hasAnnotation;
    }

    public boolean hasAnnotation(String type) {
        MethodSource<O> mutator;
        MethodSource<O> accessor;
        boolean hasAnnotation = false;
        FieldSource<O> field = this.getField();
        if (field != null) {
            hasAnnotation = field.hasAnnotation(type);
        }
        if (!hasAnnotation && (accessor = this.getAccessor()) != null) {
            hasAnnotation = accessor.hasAnnotation(type);
        }
        if (!hasAnnotation && (mutator = this.getMutator()) != null) {
            hasAnnotation = mutator.hasAnnotation(type);
        }
        return hasAnnotation;
    }
}

