/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.general;

import com.google.common.collect.Iterables;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class IterableFilter
extends GraphCondition {
    private GraphCondition wrappedCondition;
    private Integer size;

    public static IterableFilter withSize(int size) {
        return new IterableFilter(size);
    }

    public IterableFilter(int size) {
        this.size = size;
    }

    public IterableFilter withWrappedCondition(GraphCondition condition) {
        this.wrappedCondition = condition;
        return this;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        this.wrappedCondition.evaluate(event, context);
        Iterable vertices = Variables.instance((GraphRewrite)event).findVariable(this.wrappedCondition.getOutputVariablesName());
        return Iterables.size((Iterable)vertices) == this.size;
    }
}

