/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.irgen;

import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.strings.Atom;
import io.tackle.diva.Constants;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModularAnalysisScope
extends AnalysisScope {
    Set<ClassLoaderReference> moduleRefs = new LinkedHashSet<ClassLoaderReference>();

    public ModularAnalysisScope() {
        this(Collections.singleton(Language.JAVA));
    }

    public ModularAnalysisScope(Set<JavaLanguage> languages) {
        super(languages);
        this.initCoreForJava();
    }

    public ClassLoaderReference findOrCreateModuleLoader(String name, Module module, ClassLoaderReference parent) {
        Atom key = Atom.findOrCreateAsciiAtom((String)("Source:" + name));
        if (this.loadersByName.containsKey(key)) {
            return (ClassLoaderReference)this.loadersByName.get(key);
        }
        ClassLoaderReference clref = new ClassLoaderReference(key, Constants.Java, parent);
        this.loadersByName.put(clref.getName(), clref);
        this.addToScope(clref, module);
        this.moduleRefs.add(clref);
        return clref;
    }

    public Set<ClassLoaderReference> moduleLoaderRefs() {
        return this.moduleRefs;
    }

    public boolean isApplicationLoader(IClassLoader loader) {
        ClassLoaderReference clref = loader.getReference();
        return clref == ClassLoaderReference.Application || this.moduleRefs.contains(clref);
    }
}

