/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.analysis;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import io.tackle.diva.Constants;
import io.tackle.diva.Constraint;
import io.tackle.diva.Framework;
import io.tackle.diva.Trace;
import io.tackle.diva.Util;
import io.tackle.diva.analysis.SpringBootAnalysis;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServletAnalysis {
    public static List<IMethod> getEntries(IClassHierarchy cha) throws IOException {
        ArrayList<IMethod> entries = new ArrayList<IMethod>();
        for (IClass c : cha) {
            boolean isServlet = false;
            String urlPattern = null;
            if (c.isAbstract()) continue;
            for (Annotation a : Util.getAnnotations(c)) {
                if (a.getType().getName() != Constants.LJavaxWebServlet && a.getType().getName() != Constants.LJavaxWebFilter) continue;
                isServlet = true;
                for (Map.Entry e : a.getNamedArguments().entrySet()) {
                    AnnotationsReader.ElementValue v;
                    if (!"urlPatterns".equals(e.getKey()) && !"value".equals(e.getKey()) || (v = (AnnotationsReader.ElementValue)e.getValue()) == null) continue;
                    if (v instanceof AnnotationsReader.ArrayElementValue) {
                        v = ((AnnotationsReader.ArrayElementValue)v).vals[0];
                    }
                    urlPattern = "" + ((AnnotationsReader.ConstantElementValue)v).val;
                }
            }
            if (!isServlet) {
                for (IClass p : Util.superChain(c)) {
                    if (p.getName() != Constants.LJavaxHttpServlet) continue;
                    isServlet = true;
                    break;
                }
            }
            if (!isServlet) continue;
            ServletAnalysis.processServletClass(c, urlPattern, entries);
        }
        return entries;
    }

    static void processServletClass(IClass c, String urlPattern, List<IMethod> entries) {
        ArrayList servletEntries = new ArrayList();
        boolean parentImpl = false;
        for (IClass p : Util.superChain(c)) {
            for (IMethod m : p.getDeclaredMethods()) {
                if (m.isAbstract() || m.isNative() || m.getName() != Constants.doGet && m.getName() != Constants.doPost && m.getName() != Constants.doDelete && m.getName() != Constants.doFilter && m.getName() != Constants.doPut && m.getName() != Constants.service && m.getName() != Constants.init) continue;
                boolean dup = false;
                for (IMethod n : servletEntries) {
                    dup |= n.getName().equals((Object)m.getName());
                }
                if (dup) continue;
                entries.add(m);
                if (p.equals(c)) continue;
                parentImpl = true;
            }
        }
    }

    public static Trace.InstructionVisitor getContextualAnalysis(Framework fw) {
        return ServletAnalysis.getContextualAnalysisAux(fw, ServletAnalysis.getHttpParameterMatcher().with(SpringBootAnalysis.getJsonRequestMatcher()));
    }

    public static Matcher getHttpParameterMatcher() {
        return (fw, v) -> {
            if (v.isConstant() || !(v.instr() instanceof SSAAbstractInvokeInstruction)) {
                return null;
            }
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)v.instr();
            if (invoke.getDeclaredTarget().getDeclaringClass().getName() != Constants.LJavaxHttpServletRequest || invoke.getDeclaredTarget().getName() != Constants.getParameter) {
                return null;
            }
            Trace.Val v2 = v.getDef(invoke.getUse(1));
            if (!v2.isConstant() && !(v2.constant() instanceof String)) {
                return null;
            }
            return v2.toString();
        };
    }

    public static Trace.InstructionVisitor getContextualAnalysisAux(final Framework fw, Matcher matcher) {
        final LinkedHashMap coveringBranches = new LinkedHashMap();
        final LinkedHashMap defaultConstraintCache = new LinkedHashMap();
        return (trace, instr) -> {
            CGNode node = trace.node();
            if (!(instr instanceof SSAConditionalBranchInstruction)) {
                return;
            }
            SSAConditionalBranchInstruction branch = (SSAConditionalBranchInstruction)instr;
            if (branch.getOperator() != IConditionalBranchInstruction.Operator.EQ) {
                return;
            }
            Trace.Val v1 = trace.getDef(branch.getUse(1));
            if (v1 == null || !v1.isConstant() || !(v1.constant() instanceof Integer) || (Integer)v1.constant() != 0) {
                return;
            }
            Trace.Val v0 = trace.getDef(branch.getUse(0));
            if (v0 == null || v0.isConstant()) {
                return;
            }
            BitVectorIntSet phiOrigins = new BitVectorIntSet();
            IR ir = node.getIR();
            if (v0.instr() instanceof SSAPhiInstruction) {
                if (v0.trace() != trace) {
                    return;
                }
                SSAPhiInstruction phi = (SSAPhiInstruction)v0.instr();
                ISSABasicBlock bb = ir.getBasicBlockForInstruction(v0.instr());
                if (bb == null) {
                    return;
                }
                int i = 0;
                v0 = null;
                for (ISSABasicBlock pred : () -> ir.getControlFlowGraph().getPredNodes(bb)) {
                    Object v;
                    if ((v = trace.getDef(phi.getUse(i++))) == null) {
                        return;
                    }
                    if (((Trace.Val)v).isConstant() && ((Trace.Val)v).constant() instanceof Boolean && ((Boolean)((Trace.Val)v).constant()).booleanValue()) {
                        for (ISSABasicBlock pred2 : () -> ir.getControlFlowGraph().getPredNodes(pred)) {
                            if (pred2.getNumber() != pred.getNumber() - 1) {
                                return;
                            }
                            SSAInstruction last = null;
                            try {
                                last = pred2.getLastInstruction();
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                            if (last == null || !(last instanceof SSAConditionalBranchInstruction)) {
                                return;
                            }
                            phiOrigins.add(last.iIndex());
                        }
                        continue;
                    }
                    if (v0 == null && ((Trace.Val)v).isInstr()) {
                        v0 = v;
                        continue;
                    }
                    return;
                }
                if (v0 == null) {
                    return;
                }
            }
            if (!(v0.instr() instanceof SSAAbstractInvokeInstruction)) {
                return;
            }
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)v0.instr();
            if (!invoke.isDispatch() || invoke.getDeclaredTarget().getName() != Constants.equals && invoke.getDeclaredTarget().getName() != Constants.equalsIgnoreCase && invoke.getDeclaredTarget().getName() != Constants.contains) {
                return;
            }
            Trace.Val v2 = v0.getDef(invoke.getUse(0));
            Trace.Val v3 = v0.getDef(invoke.getUse(1));
            if (v2 == null || v3 == null) {
                return;
            }
            if (v2.isConstant()) {
                Trace.Val tmp = v2;
                v2 = v3;
                v3 = tmp;
            }
            if (!v3.isConstant() || !(v3.constant() instanceof String)) {
                return;
            }
            String key = matcher.apply(fw, v2);
            if (key == null) {
                return;
            }
            if (!fw.isRelevant(node)) {
                return;
            }
            if (!phiOrigins.isEmpty()) {
                BitVectorIntSet copy = new BitVectorIntSet();
                copy.copySet((IntSet)phiOrigins);
                for (Map.Entry entry : coveringBranches.entrySet()) {
                    if (!((String)entry.getKey()).equals(key)) continue;
                    block5: for (Set s : ((Map)entry.getValue()).values()) {
                        for (IntPair p : s) {
                            if (p.getX() != node.getGraphNodeId() || !phiOrigins.contains(p.getY())) continue;
                            s.add(IntPair.make((int)node.getGraphNodeId(), (int)branch.iIndex()));
                            copy.remove(p.getY());
                            continue block5;
                        }
                    }
                }
                if (!copy.isEmpty()) {
                    Util.LOGGER.fine("TODO");
                }
            }
            String val = v3.toString();
            IntPair branchId = IntPair.make((int)node.getGraphNodeId(), (int)branch.iIndex());
            if (!coveringBranches.containsKey(key)) {
                coveringBranches.put(key, new LinkedHashMap());
            }
            if (!((Map)coveringBranches.get(key)).containsKey(val)) {
                ((Map)coveringBranches.get(key)).put(val, new LinkedHashSet());
            }
            ((Set)((Map)coveringBranches.get(key)).get(val)).add(branchId);
            fw.recordContraint(new HttpParameterConstraint(fw, key, val){

                @Override
                public Set<IntPair> fallenThruBranches() {
                    return (Set)((Map)coveringBranches.get(this.key)).get(this.val);
                }

                @Override
                public Set<IntPair> takenBranches() {
                    LinkedHashSet<IntPair> res = new LinkedHashSet<IntPair>();
                    for (Map.Entry e : ((Map)coveringBranches.get(this.key)).entrySet()) {
                        res.addAll((Collection)e.getValue());
                    }
                    res.removeAll((Collection)((Map)coveringBranches.get(this.key)).get(this.val));
                    return res;
                }

                @Override
                public Constraint.BranchingConstraint defaultConstraint() {
                    if (!defaultConstraintCache.containsKey(this.key)) {
                        defaultConstraintCache.put(this.key, new HttpParameterConstraint(fw, this.key, ""){

                            @Override
                            public Constraint.BranchingConstraint defaultConstraint() {
                                return this;
                            }

                            @Override
                            public Set<IntPair> takenBranches() {
                                LinkedHashSet<IntPair> res = new LinkedHashSet<IntPair>();
                                for (Map.Entry e : ((Map)coveringBranches.get(this.key)).entrySet()) {
                                    res.addAll((Collection)e.getValue());
                                }
                                return res;
                            }

                            @Override
                            public Set<IntPair> fallenThruBranches() {
                                return Collections.emptySet();
                            }
                        });
                    }
                    return (Constraint.BranchingConstraint)defaultConstraintCache.get(this.key);
                }
            });
            Util.LOGGER.fine(key + "=" + val);
        };
    }

    public static abstract class HttpParameterConstraint
    extends Constraint.BranchingConstraint {
        String key;
        String val;

        @Override
        public String category() {
            return "http-param";
        }

        @Override
        public String type() {
            return this.key;
        }

        @Override
        public String value() {
            return this.val;
        }

        public HttpParameterConstraint(Framework fw, String key, String val) {
            super(fw);
            this.key = key;
            this.val = val;
        }
    }

    @FunctionalInterface
    public static interface Matcher {
        public String apply(Framework var1, Trace.Val var2);

        default public Matcher with(Matcher m) {
            return (fw, v) -> {
                String k = this.apply(fw, v);
                if (k != null) {
                    return k;
                }
                return m.apply(fw, v);
            };
        }
    }
}

