/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.ArchiveReport;
import org.jboss.tattletale.reporting.Dump;

public class JarReport
extends ArchiveReport {
    private static final String DIRECTORY = "jar";
    private String filename;
    private int depth;

    public JarReport(Archive archive) {
        this(archive, 1);
    }

    public JarReport(Archive archive, int depth) {
        super(DIRECTORY, 0, archive);
        StringBuffer sb = new StringBuffer(archive.getName());
        this.setFilename(sb.append(".html").toString());
        this.depth = depth;
    }

    @Override
    public void writeHtmlHead(BufferedWriter bw) throws IOException {
        if (this.depth == 1) {
            super.writeHtmlHead(bw);
        } else {
            bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + Dump.newLine());
            bw.write("<html>" + Dump.newLine());
            bw.write("<head>" + Dump.newLine());
            bw.write("  <title>JBoss Tattletale (1.3 - EAP 7): " + this.getName() + "</title>" + Dump.newLine());
            bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + Dump.newLine());
            bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"");
            for (int i = 1; i <= this.depth; ++i) {
                bw.write("../");
            }
            bw.write("style.css\">" + Dump.newLine());
            bw.write("</head>" + Dump.newLine());
        }
    }

    @Override
    public String getDirectory() {
        return DIRECTORY;
    }

    @Override
    BufferedWriter getBufferedWriter() throws IOException {
        return this.getBufferedWriter(this.getFilename());
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Name</td>" + Dump.newLine());
        bw.write("     <td>" + this.archive.getName() + "</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Class Version</td>" + Dump.newLine());
        bw.write("     <td>");
        if (50 == this.archive.getVersion()) {
            bw.write("Java 6");
        } else if (49 == this.archive.getVersion()) {
            bw.write("Java 5");
        } else if (48 == this.archive.getVersion()) {
            bw.write("J2SE 1.4");
        } else if (47 == this.archive.getVersion()) {
            bw.write("J2SE 1.3");
        } else if (46 == this.archive.getVersion()) {
            bw.write("J2SE 1.2");
        } else if (45 == this.archive.getVersion()) {
            bw.write("JSE 1.0 / JSE 1.1");
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Locations</td>" + Dump.newLine());
        bw.write("     <td>");
        bw.write("       <table>" + Dump.newLine());
        for (Location location : this.archive.getLocations()) {
            bw.write("      <tr>" + Dump.newLine());
            bw.write("        <td>" + location.getFilename() + "</td>" + Dump.newLine());
            bw.write("        <td>");
            if (location.getVersion() != null) {
                bw.write(location.getVersion());
            } else {
                bw.write("<i>Not listed</i>");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("      </tr>" + Dump.newLine());
        }
        bw.write("       </table>" + Dump.newLine());
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Profiles</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.archive.getProfiles() != null) {
            Iterator pit = this.archive.getProfiles().iterator();
            while (pit.hasNext()) {
                String p = (String)pit.next();
                bw.write(p);
                if (!pit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Manifest</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.archive.getManifest() != null) {
            Iterator<String> mit = this.archive.getManifest().iterator();
            while (mit.hasNext()) {
                String m = mit.next();
                bw.write(m);
                if (!mit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Signing information</td>" + Dump.newLine());
        bw.write("     <td>");
        if (this.archive.getSign() != null) {
            Iterator<String> sit = this.archive.getSign().iterator();
            while (sit.hasNext()) {
                String s = sit.next();
                bw.write(s);
                if (!sit.hasNext()) continue;
                bw.write("<br>");
            }
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
        bw.write("     <td>Requires</td>" + Dump.newLine());
        bw.write("     <td>");
        Iterator rit = this.archive.getRequires().iterator();
        while (rit.hasNext()) {
            String require = (String)rit.next();
            bw.write(require);
            if (!rit.hasNext()) continue;
            bw.write("<br>");
        }
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("  <tr class=\"roweven\">" + Dump.newLine());
        bw.write("     <td>Provides</td>" + Dump.newLine());
        bw.write("     <td>");
        bw.write("       <table>");
        for (Map.Entry<String, Long> entry : this.archive.getProvides().entrySet()) {
            String name = entry.getKey();
            Long serialVersionUID = entry.getValue();
            bw.write("         <tr>" + Dump.newLine());
            bw.write("           <td>" + name + "</td>" + Dump.newLine());
            if (serialVersionUID != null) {
                bw.write("           <td>" + serialVersionUID + "</td>" + Dump.newLine());
            } else {
                bw.write("           <td>&nbsp;</td>" + Dump.newLine());
            }
            bw.write("         </tr>" + Dump.newLine());
        }
        bw.write("       </table>");
        bw.write("</td>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>" + this.archive.getName() + "</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    private String getFilename() {
        return this.filename;
    }

    private void setFilename(String filename) {
        this.filename = filename;
    }
}

