/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.gss.middleware.tattletale.reports;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.reporting.Report;

public class ReportSetBuilder {
    private final boolean allReports;
    private final String outputDir;
    private final Properties filters;
    private Set<String> reportSet;
    private SortedSet<Report> returnReportSet = new TreeSet<Report>();
    private final Map<String, Object> reportParameters = new HashMap<String, Object>();

    ReportSetBuilder(String destination, boolean allReports, Set<String> reportSet, Properties filters) throws Exception {
        this.outputDir = this.setupOutputDir(destination);
        this.allReports = allReports;
        this.reportSet = reportSet;
        this.filters = filters;
    }

    public void addReportParameter(String setMethodName, Object parameter) {
        this.reportParameters.put(setMethodName, parameter);
    }

    void clear() {
        this.returnReportSet = new TreeSet<Report>();
    }

    void addReport(Report report) {
        if (this.allReports || this.reportSet.contains(report.getId())) {
            if (this.filters != null && this.filters.getProperty(report.getId()) != null) {
                report.setFilter(this.filters.getProperty(report.getId()));
            }
            report.generate(this.outputDir);
            this.returnReportSet.add(report);
        }
    }

    void addReport(Class<? extends Report> reportDef) throws Exception {
        Method[] allMethods;
        Report report = reportDef.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Method m : allMethods = reportDef.getMethods()) {
            if (!this.reportParameters.containsKey(m.getName())) continue;
            m.invoke((Object)report, this.reportParameters.get(m.getName()));
        }
        this.addReport(report);
    }

    SortedSet<Report> getReportSet() {
        return this.returnReportSet;
    }

    String getOutputDir() {
        return this.outputDir;
    }

    private String setupOutputDir(String outputDir) throws IOException {
        File outputDirFile = new File(outputDir = !outputDir.substring(outputDir.length() - 1).equals(File.separator) ? outputDir + File.separator : outputDir);
        if (outputDirFile.exists() && !outputDirFile.equals(new File("."))) {
            this.recursiveDelete(outputDirFile);
        }
        if (!outputDirFile.equals(new File(".")) && !outputDirFile.mkdirs()) {
            throw new IOException("Cannot create directory: " + outputDir);
        }
        return outputDir;
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }
}

