/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.util.Logging;

public class Util {
    private static final Logger LOG = Logging.get(Util.class);

    public static void deleteGraphDataUnlessInhibited(WindupConfiguration windupConfiguration, Path graphPath) {
        Boolean keep = (Boolean)windupConfiguration.getOptionMap().get("keepWorkDirs");
        if (keep == null || !keep.booleanValue()) {
            LOG.info("Deleting graph directory (see --keepWorkDirs): " + graphPath.toFile().getPath());
            try {
                FileUtils.deleteDirectory((File)graphPath.toFile());
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Failed deleting graph directory: " + graphPath.toFile().getPath() + System.lineSeparator() + "\tDue to: " + ex.getMessage(), ex);
            }
        }
    }
}

