/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.yaml;

import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.ClassifyFileTypesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.yaml.model.YamlFileModel;
import org.jboss.windup.rules.files.FileMapping;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverYamlFilesRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(DiscoverYamlFilesRuleProvider.class.getName());

    public DiscoverYamlFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverYamlFilesRuleProvider.class).setPhase(ClassifyFileTypesPhase.class));
    }

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule((Rule)FileMapping.from((String)".*\\.yml$").to(YamlFileModel.class)).addRule((Rule)FileMapping.from((String)".*\\.yaml$").to(YamlFileModel.class)).addRule().when((Condition)Query.fromType(YamlFileModel.class)).perform((Operation)new AbstractIterationOperation<YamlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, YamlFileModel payload) {
                YamlFileModel yamlFileModel = (YamlFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, YamlFileModel.class);
            }

            public String toString() {
                return "IndexYamlFilesMetadata";
            }
        });
    }
}

