/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma.typeresolvers;

import com.syncleus.ferma.AbstractEdgeFrame;
import com.syncleus.ferma.AbstractVertexFrame;
import com.syncleus.ferma.EdgeFrame;
import com.syncleus.ferma.ReflectionCache;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;

public class PolymorphicTypeResolver
implements TypeResolver {
    public static final String TYPE_RESOLUTION_KEY = "ferma_type";
    private final ReflectionCache reflectionCache;
    private final String typeResolutionKey;

    public PolymorphicTypeResolver() {
        this.reflectionCache = new ReflectionCache();
        this.typeResolutionKey = TYPE_RESOLUTION_KEY;
    }

    public PolymorphicTypeResolver(String typeResolutionKey) {
        this.reflectionCache = new ReflectionCache();
        this.typeResolutionKey = typeResolutionKey;
    }

    public PolymorphicTypeResolver(ReflectionCache reflectionCache) {
        this.reflectionCache = reflectionCache;
        this.typeResolutionKey = TYPE_RESOLUTION_KEY;
    }

    public PolymorphicTypeResolver(ReflectionCache reflectionCache, String typeResolutionKey) {
        this.reflectionCache = reflectionCache;
        this.typeResolutionKey = typeResolutionKey;
    }

    @Override
    public <T> Class<? extends T> resolve(Element element, Class<T> kind) {
        Property nodeClazzProperty = element.property(this.typeResolutionKey);
        if (!nodeClazzProperty.isPresent()) {
            return kind;
        }
        String nodeClazz = (String)nodeClazzProperty.value();
        Class nodeKind = this.reflectionCache.forName(nodeClazz);
        if (kind.isAssignableFrom(nodeKind) || kind.equals(VertexFrame.class) || kind.equals(EdgeFrame.class) || kind.equals(AbstractVertexFrame.class) || kind.equals(AbstractEdgeFrame.class) || kind.equals(Object.class)) {
            return nodeKind;
        }
        return kind;
    }

    @Override
    public Class<?> resolve(Element element) {
        Property typeResolutionName = element.property(this.typeResolutionKey);
        if (typeResolutionName.isPresent()) {
            return this.reflectionCache.forName((String)typeResolutionName.value());
        }
        return null;
    }

    @Override
    public void init(Element element, Class<?> kind) {
        element.property(this.typeResolutionKey, (Object)kind.getName());
    }

    @Override
    public void deinit(Element element) {
        element.property(this.typeResolutionKey).remove();
    }

    @Override
    public <P extends Element, T extends Element> GraphTraversal<P, T> hasType(GraphTraversal<P, T> traverser, Class<?> type) {
        Set<? extends String> allAllowedValues = this.reflectionCache.getSubTypeNames(type.getName());
        return traverser.has(this.typeResolutionKey, P.within(allAllowedValues));
    }

    @Override
    public <P extends Element, T extends Element> GraphTraversal<P, T> hasNotType(GraphTraversal<P, T> traverser, Class<?> type) {
        final Set<? extends String> allAllowedValues = this.reflectionCache.getSubTypeNames(type.getName());
        return traverser.filter(new Predicate<Traverser<T>>(){

            @Override
            public boolean test(Traverser<T> toCheck) {
                Property property = ((Element)toCheck.get()).property(PolymorphicTypeResolver.this.typeResolutionKey);
                if (!property.isPresent()) {
                    return true;
                }
                String resolvedType = (String)property.value();
                return !allAllowedValues.contains(resolvedType);
            }
        });
    }
}

