/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class ReflectionsIterables {
    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        if (iterable == null) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        T res = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        ArrayList<T> res = new ArrayList<T>();
        for (T aEl : a) {
            res.add(aEl);
        }
        for (T bEl : b) {
            res.add(bEl);
        }
        return res;
    }

    public static <T> Set<T> makeSetOf(Iterable<? extends T> a) {
        HashSet<T> res = new HashSet<T>();
        for (T aEl : a) {
            res.add(aEl);
        }
        return res;
    }

    public static boolean contains(Iterable<?> iterable, Object element) {
        for (Object el : iterable) {
            if (!el.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static <F, T> Iterable<T> transform(Iterable<F> fromIterable, Function<? super F, ? extends T> function) {
        ArrayList<T> res = new ArrayList<T>();
        if (fromIterable != null) {
            for (F el : fromIterable) {
                res.add(function.apply(el));
            }
        }
        return res;
    }

    public static <F, T> Set<T> transformToSet(Iterable<F> fromIterable, Function<? super F, ? extends T> function) {
        HashSet<T> res = new HashSet<T>();
        if (fromIterable != null) {
            for (F el : fromIterable) {
                res.add(function.apply(el));
            }
        }
        return res;
    }
}

