/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.model;

import org.apache.commons.lang3.StringUtils;

public enum IssueDisplayMode {
    DETAIL_ONLY("detail-only"),
    SUMMARY_ONLY("summary-only"),
    ALL("all");

    private String name;

    private IssueDisplayMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static IssueDisplayMode parse(String value) {
        for (IssueDisplayMode issueDisplayMode : IssueDisplayMode.values()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)issueDisplayMode.name())) {
                return issueDisplayMode;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)issueDisplayMode.toString())) continue;
            return issueDisplayMode;
        }
        throw new IllegalArgumentException("No IssueDisplay mode available for: " + value);
    }

    public static class Defaults {
        public static final IssueDisplayMode DEFAULT_DISPLAY_MODE = ALL;
    }
}

