/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import freemarker.template.DefaultMapAdapter;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.SourcesAndTargets;

public class GetSourcesAndTargetsMethod
implements WindupFreeMarkerMethod {
    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.isEmpty()) {
            throw new TemplateModelException("Method " + this.getMethodName() + " requires the following parameters (GraphRewrite event, ProjectModel project)");
        }
        Map problemSummariesArg = (Map)((DefaultMapAdapter)arguments.get(0)).getWrappedObject();
        List<ProblemSummary> problemSummaries = problemSummariesArg.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Set<String> sourceTechs = this.getTechnologiesSet(problemSummaries, ProblemSummary::getSourceTechnologies);
        Set<String> targetTechs = this.getTechnologiesSet(problemSummaries, ProblemSummary::getTargetTechnologies);
        Map<String, Set<Object>> issuesBySourceTech = sourceTechs.stream().map(st -> Map.entry(st, problemSummaries.stream().filter(ps -> ps.getSourceTechnologies().contains(st)).map(ProblemSummary::getId).collect(Collectors.toSet()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Set<Object>> issuesByTargetTech = targetTechs.stream().map(tt -> Map.entry(tt, problemSummaries.stream().filter(ps -> ps.getTargetTechnologies().contains(tt)).map(ProblemSummary::getId).collect(Collectors.toSet()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new SourcesAndTargets(issuesBySourceTech, issuesByTargetTech, sourceTechs, targetTechs);
    }

    private Set<String> getTechnologiesSet(List<ProblemSummary> problemSummaries, Function<ProblemSummary, List<String>> techType) {
        return problemSummaries.stream().map(techType).map(Set::copyOf).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public String getMethodName() {
        return WindupFreeMarkerMethod.super.getMethodName();
    }

    @Override
    public String getDescription() {
        return "Returns all the sources and targets present in the hints";
    }

    @Override
    public void setContext(GraphRewrite event) {
        WindupFreeMarkerMethod.super.setContext(event);
    }
}

