/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;

public class IterableToListMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "iterableToList";

    @Override
    public void setContext(GraphRewrite event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        try {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Error, method expects one argument (an Iterable)");
            }
            Iterable iterable = FreeMarkerUtil.freemarkerWrapperToIterable(arguments.get(0));
            if (iterable instanceof List) {
                List list = (List)iterable;
                return list;
            }
            ArrayList list = new ArrayList();
            iterable.iterator().forEachRemaining(list::add);
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            ExecutionStatistics.get().end(NAME);
        }
    }

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Turns the given Iterable into a List.";
    }
}

