/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.service.EffortReportService;
import org.jboss.windup.util.ExecutionStatistics;

public class GetEffortDescriptionForPoints
implements WindupFreeMarkerMethod {
    private static final String NAME = "getEffortDescriptionForPoints";

    @Override
    public String getDescription() {
        return "Given a number of points, return a short textual description (eg, Trivial or Complex).";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() < 1) {
            throw new TemplateModelException("Error, method expects one or two arguments (Integer, [verbosity:String])");
        }
        SimpleNumber simpleNumber = (SimpleNumber)arguments.get(0);
        int effort = simpleNumber.getAsNumber().intValue();
        EffortReportService.Verbosity verbosity = EffortReportService.Verbosity.SHORT;
        if (arguments.size() > 1) {
            TemplateScalarModel verbosityModel = (TemplateScalarModel)arguments.get(1);
            String verbosityString = verbosityModel.getAsString();
            verbosity = EffortReportService.Verbosity.valueOf(verbosityString.toUpperCase());
        }
        String result = EffortReportService.getEffortLevelDescription(verbosity, effort);
        ExecutionStatistics.get().end(NAME);
        return result;
    }
}

