/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class TechnologyTagExists
extends GraphCondition {
    private String namePattern;
    private String versionPattern;
    private String filename;

    private TechnologyTagExists(String namePattern) {
        this.namePattern = "[\\s\\S]*" + namePattern + "[\\s\\S]*";
    }

    public static TechnologyTagExists withName(String namePattern) {
        return new TechnologyTagExists(namePattern);
    }

    public TechnologyTagExists withVersion(String versionPattern) {
        this.versionPattern = "[\\s\\S]*" + versionPattern + "[\\s\\S]*";
        return this;
    }

    public TechnologyTagExists in(String filename) {
        this.filename = filename;
        return this;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        QueryBuilderFind q = Query.fromType(TechnologyTagModel.class);
        if (StringUtils.isNotBlank((CharSequence)this.filename)) {
            q.piped(new QueryGremlinCriterion(){
                private static final String TECHNOLOGYTAG_STEP = "technologyTagModel";

                public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                    pipeline.as(TECHNOLOGYTAG_STEP, new String[0]);
                    pipeline.out(new String[]{"techTagToFileModel"});
                    pipeline.has("fileName", (Object)TechnologyTagExists.this.filename);
                    pipeline.select(TECHNOLOGYTAG_STEP);
                }
            });
        }
        q.withProperty("name", QueryPropertyComparisonType.REGEX, (Object)this.namePattern);
        if (this.versionPattern != null) {
            q.withProperty("version", QueryPropertyComparisonType.REGEX, (Object)this.versionPattern);
        }
        return q.evaluate((Rewrite)event, context);
    }
}

