/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternBuilder;

public class TechnologyTag
extends ParameterizedIterationOperation<FileModel> {
    private static final Logger LOG = Logging.get(TechnologyTag.class);
    private final RegexParameterizedPatternBuilder nameBuilder;
    private RegexParameterizedPatternBuilder version;
    private TechnologyTagLevel technologyTagLevel;

    private TechnologyTag(String tagName) {
        this.nameBuilder = new RegexParameterizedPatternBuilder(tagName);
        this.technologyTagLevel = TechnologyTagLevel.INFORMATIONAL;
    }

    public static TechnologyTag withName(String tagName) {
        return new TechnologyTag(tagName);
    }

    public TechnologyTag withTechnologyTagLevel(TechnologyTagLevel technologyTagLevel) {
        this.technologyTagLevel = technologyTagLevel;
        return this;
    }

    public TechnologyTag withVersion(String version) {
        this.version = new RegexParameterizedPatternBuilder(version);
        return this;
    }

    public FileModel resolvePayload(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        this.checkVariableName(event, context);
        if (payload instanceof FileReferenceModel) {
            return ((FileReferenceModel)payload).getFile();
        }
        if (payload instanceof FileModel) {
            return (FileModel)payload;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performParameterized(GraphRewrite event, EvaluationContext context, FileModel payload) {
        ExecutionStatistics.get().begin("TechnologyTag.performParameterized");
        try {
            GraphContext graphContext = event.getGraphContext();
            TechnologyTagService technologyTagService = new TechnologyTagService(graphContext);
            if (this.version != null) {
                technologyTagService.addTagToFileModel(payload, this.nameBuilder.build((Rewrite)event, context), this.technologyTagLevel, this.version.build((Rewrite)event, context));
            } else {
                technologyTagService.addTagToFileModel(payload, this.nameBuilder.build((Rewrite)event, context), this.technologyTagLevel);
            }
            LOG.info("TechnologyTag added to " + payload.getPrettyPathWithinProject() + " [" + this + "] ");
        }
        finally {
            ExecutionStatistics.get().end("TechnologyTag.performParameterized");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TechnologyTag.withName(").append(this.nameBuilder.toString()).append(")");
        result.append(".withVersion(").append(this.version).append(")");
        result.append(".withTechnologyTagLevel(").append((Object)this.technologyTagLevel).append(")");
        return result.toString();
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> parameters = new HashSet<String>(this.nameBuilder.getRequiredParameterNames());
        if (this.version != null) {
            parameters.addAll(this.version.getRequiredParameterNames());
        }
        return parameters;
    }

    public void setParameterStore(ParameterStore store) {
        this.nameBuilder.setParameterStore(store);
        if (this.version != null) {
            this.version.setParameterStore(store);
        }
    }
}

