/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class HintExists
extends GraphCondition {
    private String filename;
    private String messagePattern;

    private HintExists(String messagePattern) {
        this.messagePattern = "[\\s\\S]*" + messagePattern + "[\\s\\S]*";
    }

    public static HintExists withMessage(String messagePattern) {
        return new HintExists(messagePattern);
    }

    public HintExists in(String filename) {
        this.filename = filename;
        return this;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        QueryBuilderFind q = Query.fromType(InlineHintModel.class);
        if (StringUtils.isNotBlank((CharSequence)this.filename)) {
            q.piped(new QueryGremlinCriterion(){
                private static final String HINT_STEP = "hintModel";

                public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                    pipeline.as(HINT_STEP, new String[0]);
                    pipeline.out(new String[]{"file"});
                    pipeline.has("fileName", (Object)HintExists.this.filename);
                    pipeline.select(HINT_STEP);
                }
            });
        }
        q.withProperty("InlineHintModel-hint", QueryPropertyComparisonType.REGEX, (Object)this.messagePattern);
        return q.evaluate((Rewrite)event, context);
    }

    public String toString() {
        return "HintExists.withMessage('" + this.messagePattern + "').in(" + this.filename + ")";
    }
}

