/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationFilter;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class HasHint
extends AbstractIterationFilter<WindupVertexFrame>
implements Parameterized {
    private RegexParameterizedPatternParser messagePattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        ExecutionStatistics.get().begin(HasHint.class.getCanonicalName());
        try {
            ParameterizedPatternResult parseResult;
            Iterable<InlineHintModel> hints;
            boolean result = false;
            InlineHintService service = new InlineHintService(event.getGraphContext());
            if (payload instanceof FileReferenceModel) {
                hints = service.getHintsForFileReference((FileReferenceModel)payload);
                if (this.messagePattern == null) {
                    result = hints.iterator().hasNext();
                } else {
                    for (InlineHintModel c : hints) {
                        parseResult = this.messagePattern.parse(c.getHint());
                        if (!parseResult.matches() || !parseResult.isValid((Rewrite)event, context)) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (payload instanceof FileModel) {
                hints = service.getHintsForFile((FileModel)payload);
                if (this.messagePattern == null) {
                    result = hints.iterator().hasNext();
                } else {
                    for (InlineHintModel c : hints) {
                        parseResult = this.messagePattern.parse(c.getHint());
                        if (!parseResult.matches() || !parseResult.isValid((Rewrite)event, context)) continue;
                        result = true;
                        break;
                    }
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            ExecutionStatistics.get().end(HasHint.class.getCanonicalName());
        }
    }

    public String getMessagePattern() {
        if (this.messagePattern != null) {
            return this.messagePattern.getPattern();
        }
        return null;
    }

    public void setMessagePattern(String titlePattern) {
        if (titlePattern != null) {
            this.messagePattern = new RegexParameterizedPatternParser(titlePattern);
        }
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.messagePattern != null) {
            result.addAll(this.messagePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.messagePattern != null) {
            this.messagePattern.setParameterStore(store);
        }
    }
}

