/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.category;

import com.syncleus.ferma.FramedGraph;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.category.DuplicateIssueCategoryException;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.ocpsoft.rewrite.context.Context;

public class IssueCategoryRegistry {
    public static final String MANDATORY = "mandatory";
    public static final String OPTIONAL = "optional";
    public static final String POTENTIAL = "potential";
    public static final String CLOUD_MANDATORY = "cloud-mandatory";
    public static final String INFORMATION = "information";
    public static final String DEFAULT = "optional";
    private Map<String, IssueCategory> issueCategories = new ConcurrentHashMap<String, IssueCategory>();

    public static IssueCategoryRegistry instance(Context context) {
        IssueCategoryRegistry registry = (IssueCategoryRegistry)context.get(IssueCategoryRegistry.class);
        if (registry == null) {
            registry = new IssueCategoryRegistry();
            context.put(IssueCategoryRegistry.class, (Object)registry);
        }
        return registry;
    }

    public IssueCategoryRegistry() {
        this.addDefaults();
    }

    public void attachToGraph(GraphContext graphContext) {
        for (IssueCategory issueCategory : this.issueCategories.values()) {
            IssueCategoryModel model = (IssueCategoryModel)graphContext.create(IssueCategoryModel.class);
            model.setCategoryID(issueCategory.getCategoryID());
            model.setName(issueCategory.getName());
            model.setDescription(issueCategory.getDescription());
            model.setOrigin(issueCategory.getOrigin());
            model.setPriority(issueCategory.getPriority());
        }
    }

    public static IssueCategoryModel loadFromGraph(GraphContext graphContext, String issueCategoryID) {
        return IssueCategoryRegistry.loadFromGraph((FramedGraph)graphContext.getFramed(), issueCategoryID);
    }

    public static IssueCategoryModel loadFromGraph(FramedGraph framedGraph, String issueCategoryID) {
        List vertices = framedGraph.traverse(g -> framedGraph.getTypeResolver().hasType(g.V(new Object[0]), IssueCategoryModel.class)).traverse(g -> g.has("categoryID", (Object)issueCategoryID)).getRawTraversal().toList();
        IssueCategoryModel result = null;
        for (Vertex vertex : vertices) {
            if (result != null) {
                throw new DuplicateIssueCategoryException("Found more than one issue category for this id: " + issueCategoryID);
            }
            result = (IssueCategoryModel)framedGraph.frameElement((Element)vertex, IssueCategoryModel.class);
        }
        return result;
    }

    public static IssueCategoryModel loadFromGraph(GraphContext graphContext, IssueCategory issueCategory) {
        return IssueCategoryRegistry.loadFromGraph((FramedGraph)graphContext.getFramed(), issueCategory.getCategoryID());
    }

    public void addCategory(IssueCategory category) throws DuplicateIssueCategoryException {
        IssueCategory original = this.issueCategories.get(category.getCategoryID());
        if (original != null && !original.isPlaceholder()) {
            StringBuilder message = new StringBuilder("Issue category (ID: ").append(category.getCategoryID()).append(") is defined at the following locations:");
            message.append(OperatingSystemUtils.getLineSeparator());
            message.append("\t1: " + original.getOrigin());
            message.append("\t2: " + category.getOrigin());
            throw new DuplicateIssueCategoryException(message.toString());
        }
        this.issueCategories.put(category.getCategoryID(), category);
    }

    public IssueCategory getByID(String categoryID) {
        IssueCategory issueCategory = this.issueCategories.get(categoryID);
        if (issueCategory == null) {
            issueCategory = new IssueCategory(categoryID, "placeholder", categoryID, categoryID, 0, true);
            this.issueCategories.put(categoryID, issueCategory);
        }
        return issueCategory;
    }

    public List<IssueCategory> getIssueCategories() {
        return this.issueCategories.values().stream().sorted((category1, category2) -> category1.getPriority() - category2.getPriority()).collect(Collectors.toList());
    }

    private void addDefaults() {
        this.issueCategories.putIfAbsent(MANDATORY, new IssueCategory(MANDATORY, IssueCategoryRegistry.class.getCanonicalName(), "Mandatory", MANDATORY, 1000, true));
        this.issueCategories.putIfAbsent("optional", new IssueCategory("optional", IssueCategoryRegistry.class.getCanonicalName(), "Optional", "optional", 1000, true));
        this.issueCategories.putIfAbsent(POTENTIAL, new IssueCategory(POTENTIAL, IssueCategoryRegistry.class.getCanonicalName(), "Potential Issues", POTENTIAL, 1000, true));
        this.issueCategories.putIfAbsent(CLOUD_MANDATORY, new IssueCategory(CLOUD_MANDATORY, IssueCategoryRegistry.class.getCanonicalName(), "Cloud Mandatory", CLOUD_MANDATORY, 1000, true));
        this.issueCategories.putIfAbsent(INFORMATION, new IssueCategory(INFORMATION, IssueCategoryRegistry.class.getCanonicalName(), "Information", INFORMATION, 1000, true));
    }
}

