/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.modules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.modules.ModuleIdentifier;

class AddonModuleIdentifierCache {
    private final Map<Addon, ModuleIdentifier> map = new HashMap<Addon, ModuleIdentifier>();

    AddonModuleIdentifierCache() {
    }

    public void clear(Addon addon) {
        this.map.remove(addon);
    }

    public void dispose() {
        this.map.clear();
    }

    public ModuleIdentifier getModuleId(Addon addon) {
        return this.map.computeIfAbsent(addon, a -> ModuleIdentifier.fromString((String)(this.toModuleId(a.getId()) + "_" + UUID.randomUUID().toString())));
    }

    private String toModuleId(AddonId id) {
        return id.getName().replaceAll(":", ".") + ":" + id.getVersion();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Addon, ModuleIdentifier>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Addon, ModuleIdentifier> entry = iterator.next();
            builder.append(entry.getKey()).append(" -> ").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public Addon getAddon(ModuleIdentifier id) {
        for (Map.Entry<Addon, ModuleIdentifier> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(id)) continue;
            return entry.getKey();
        }
        return null;
    }
}

