/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdgeNameProvider;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.impl.graph.AddonVertexNameProvider;
import org.jboss.forge.furnace.impl.graph.OptimizedAddonGraph;
import org.jboss.forge.furnace.impl.graph.PrintGraphTraversalListener;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.Version;
import org.jgrapht.DirectedGraph;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class MasterGraph {
    private final DirectedGraph<AddonVertex, AddonDependencyEdge> graph = new SimpleDirectedGraph(AddonDependencyEdge.class);

    public DirectedGraph<AddonVertex, AddonDependencyEdge> getGraph() {
        return this.graph;
    }

    public void merge(final OptimizedAddonGraph other) {
        if (other.getGraph().vertexSet().isEmpty()) {
            return;
        }
        if (this.graph.vertexSet().isEmpty()) {
            for (AddonVertex vertex : other.getGraph().vertexSet()) {
                this.mergeVertex(other, vertex);
            }
        } else {
            DepthFirstIterator iterator = new DepthFirstIterator(other.getGraph());
            iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

                public void vertexTraversed(VertexTraversalEvent<AddonVertex> event) {
                    MasterGraph.this.mergeVertex(other, (AddonVertex)event.getVertex());
                }
            });
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    private AddonVertex mergeVertex(OptimizedAddonGraph other, AddonVertex otherVertex) {
        AddonVertex result = null;
        Set<AddonVertex> localVertices = this.getVertices(otherVertex.getName(), otherVertex.getVersion());
        AddonView view = other.getAddonView();
        if (localVertices.isEmpty()) {
            result = new AddonVertex(otherVertex, view);
            this.graph.addVertex((Object)result);
            this.copySubtree(result, other, otherVertex);
        } else {
            boolean exists = false;
            for (AddonVertex localVertex : localVertices) {
                if (!this.isSubtreeEquivalent(localVertex, other.getGraph(), otherVertex)) continue;
                exists = true;
                if (!localVertex.getViews().contains(view)) {
                    result = new AddonVertex(localVertex, view);
                    this.replaceVertex(localVertex, result);
                    continue;
                }
                result = localVertex;
            }
            if (!exists) {
                result = new AddonVertex(otherVertex, view);
                this.graph.addVertex((Object)result);
                this.copySubtree(result, other, otherVertex);
            }
        }
        return result;
    }

    public Set<AddonVertex> getVertices(String name, Version version) {
        HashSet<AddonVertex> result = new HashSet<AddonVertex>();
        for (AddonVertex vertex : this.getGraph().vertexSet()) {
            if (!vertex.getName().equals(name) || version.compareTo((Object)vertex.getVersion()) != 0) continue;
            result.add(vertex);
        }
        return result;
    }

    public boolean isSubtreeEquivalent(AddonVertex localVertex, DirectedGraph<AddonVertex, AddonDependencyEdge> otherGraph, AddonVertex otherVertex) {
        Set otherOutgoing = otherGraph.outgoingEdgesOf((Object)otherVertex);
        Set localOutgoing = this.graph.outgoingEdgesOf((Object)localVertex);
        if (otherOutgoing.size() == localOutgoing.size()) {
            for (AddonDependencyEdge otherEdge : otherOutgoing) {
                AddonVertex otherTarget = (AddonVertex)this.graph.getEdgeTarget((Object)otherEdge);
                Set<AddonVertex> localCandidates = this.getVertices(otherTarget.getName(), otherTarget.getVersion());
                boolean found = false;
                if (!localCandidates.isEmpty()) {
                    for (AddonVertex candidate : localCandidates) {
                        AddonDependencyEdge localEdge = (AddonDependencyEdge)((Object)this.graph.getEdge((Object)localVertex, (Object)candidate));
                        if (localEdge == null || !this.isSubtreeEquivalent(candidate, otherGraph, otherTarget)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void replaceVertex(AddonVertex original, AddonVertex replacement) {
        Set incoming = this.graph.incomingEdgesOf((Object)original);
        Set outgoing = this.graph.outgoingEdgesOf((Object)original);
        this.graph.addVertex((Object)replacement);
        for (AddonDependencyEdge edge : incoming) {
            this.graph.addEdge((Object)((AddonVertex)this.graph.getEdgeSource((Object)edge)), (Object)replacement, (Object)new AddonDependencyEdge(edge.getVersionRange(), edge.isExported()));
        }
        for (AddonDependencyEdge edge : outgoing) {
            this.graph.addEdge((Object)replacement, (Object)((AddonVertex)this.graph.getEdgeTarget((Object)edge)), (Object)new AddonDependencyEdge(edge.getVersionRange(), edge.isExported()));
        }
        this.graph.removeVertex((Object)original);
    }

    private void copySubtree(AddonVertex localVertex, OptimizedAddonGraph other, AddonVertex vertex) {
        Set outgoing = other.getGraph().outgoingEdgesOf((Object)vertex);
        for (AddonDependencyEdge edge : outgoing) {
            AddonVertex target = (AddonVertex)other.getGraph().getEdgeTarget((Object)edge);
            AddonVertex localTarget = this.mergeVertex(other, target);
            this.graph.addEdge((Object)localVertex, (Object)localTarget, (Object)new AddonDependencyEdge(edge.getVersionRange(), edge.isExported()));
        }
    }

    public String toString() {
        DepthFirstIterator iterator = new DepthFirstIterator(this.getGraph());
        StringBuilder builder = new StringBuilder();
        iterator.addTraversalListener((TraversalListener)new PrintGraphTraversalListener(this.getGraph(), builder));
        while (iterator.hasNext()) {
            iterator.next();
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toDOT(File file) {
        FileWriter fw = null;
        try {
            DOTExporter exporter = new DOTExporter((VertexNameProvider)new IntegerNameProvider(), (VertexNameProvider)new AddonVertexNameProvider(), (EdgeNameProvider)new AddonDependencyEdgeNameProvider());
            fw = new FileWriter(file);
            exporter.export((Writer)fw, this.graph);
            fw.flush();
            Streams.closeQuietly((Closeable)fw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Streams.closeQuietly(fw);
        }
    }
}

