/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.impl.addons.AddonRunnable;
import org.jboss.forge.furnace.impl.addons.NullServiceRegistry;
import org.jboss.forge.furnace.impl.event.NullEventManager;
import org.jboss.forge.furnace.impl.util.NullFuture;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;

public class AddonState {
    private Future<Void> future = new NullFuture<Object>(null);
    private Set<AddonDependency> dependencies = new LinkedHashSet<AddonDependency>();
    private Set<AddonDependency> missingDependencies = new LinkedHashSet<AddonDependency>();
    private AddonRepository repository;
    private ServiceRegistry registry = NullServiceRegistry.INSTANCE;
    private EventManager eventManager = NullEventManager.INSTANCE;
    private AddonRunnable runnable;
    private ClassLoader loader;

    public AddonState(Set<AddonDependency> dependencies, AddonRepository repository, ClassLoader loader) {
        Assert.notNull(dependencies, (String)"Addon dependency set must not be null.");
        Assert.notNull((Object)repository, (String)"Addon repository must not be null.");
        Assert.notNull((Object)loader, (String)"Addon ClassLoader must not be null.");
        this.dependencies = dependencies;
        this.repository = repository;
        this.loader = loader;
    }

    public AddonState(Set<AddonDependency> missingDependencies) {
        Assert.notNull(missingDependencies, (String)"Missing dependency set must not be null.");
        this.missingDependencies = missingDependencies;
    }

    public AddonState() {
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Set<AddonDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<AddonDependency> getMissingDependencies() {
        return this.missingDependencies;
    }

    public Future<Void> getFuture() {
        return this.future;
    }

    public void setFuture(Future<Void> future) {
        this.future = future;
    }

    public AddonRepository getRepository() {
        return this.repository;
    }

    public AddonRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(AddonRunnable runnable) {
        this.runnable = runnable;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.registry;
    }

    public void setServiceRegistry(ServiceRegistry registry) {
        this.registry = registry != null ? registry : NullServiceRegistry.INSTANCE;
    }

    public void setEventManager(EventManager manager) {
        this.eventManager = manager != null ? manager : NullEventManager.INSTANCE;
    }
}

